<?php
namespace wcf\system\event\listener;
use wcf\system\cache\builder\ApplicationCacheBuilder;
use wcf\system\event\IEventListener;
use wcf\system\WCF;
use wcf\util\ArrayUtil;
use wcf\util\JSON;
use wcf\util\StringUtil;

/**
 * Dereferer listener
 *
 * @author	Sascha Greuel, Sonnenspeer
 * @copyright	2014-2015 Sonnenspeer
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 */
class DerefererListener implements IEventListener {
	/**
	 * @see	\wcf\system\event\IEventListener::execute()
	 */
	public function execute($eventObj, $className, $eventName) {
		$applicationURLs = $whitelist = array();
		
		// application urls
		$applicationCache = ApplicationCacheBuilder::getInstance()->getData();
		
		foreach ($applicationCache['application'] as $application) {
			$applicationURLs[] = str_replace('https://', 'http://', mb_strtolower($application->getPageURL()));
		}
		
		// whitelist urls
		$whitelist = ArrayUtil::trim(explode("\n", mb_strtolower(StringUtil::unifyNewlines(EXTERNALLINKS_WHITELIST))));
		
		WCF::getTPL()->assign(array(
			'derefererApplicationURLs' => JSON::encode($applicationURLs),
			'whitelist' => (!empty($whitelist) ? JSON::encode($whitelist) : '')
		));
	}
}
