/**
 * @author	Sascha Greuel, Sonnenspeer
 * @copyright	2014-2015 Sonnenspeer
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 */

WCF.Dereferer = Class.extend({
	/**
	 * @var array
	 */
	applicationURLs: [],
	
	/**
	 * @var array
	 */
	whitelist: [],
	
	init: function(appURLs, whitelist) {
		var $applicationURLs = $.parseJSON(appURLs);
		var $whitelist = (whitelist ? $.parseJSON(whitelist) : []);
		
		if (!this.applicationURLs.length && !this.applicationURLs.length) {
			for (var $index in $applicationURLs) {
				this.applicationURLs.push($applicationURLs[$index]);
			}
		}
		
		if ($whitelist.length && !this.whitelist.length) {
			for (var $index in $whitelist) {
				if ($whitelist[$index].length) {
					this.whitelist.push($whitelist[$index]);
				}
			}
		}
	},
	
	isInternalURL: function(url) {
		url = url.toLowerCase().replace(/^https(?=:\/\/)/, 'http');
		
		for (var $index in this.applicationURLs) {
			var $applicationURL = this.applicationURLs[$index].toLowerCase().replace(/^https(?=:\/\/)/, 'http');
			
			if (url.slice(0, $applicationURL.length) == $applicationURL) {
				return true;
			}
		}
		
		return false;
	},
	
	isWhitelisted: function(url) {
		for (var $index in this.whitelist) {
			if (!this.executeWordFilter(url, this.whitelist)) {
				return true;
			}
		}
		
		return false;
	},
	
	executeWordFilter: function(word, filter) {
		var $word = word.toLowerCase();
		
		if (filter.length) {
			for (var $index in filter) {
				var $forbiddenName = filter[$index].toLowerCase();
				
				if ($forbiddenName.indexOf('*')) {
					$forbiddenName = this.preg_quote($forbiddenName, '/').split('\\*').join('.*');
					
					if ($word.match(new RegExp($forbiddenName))) {
						return false;
					}
				} else if ($word == $forbiddenName) {
					return false;
				}
			}
		}
		
		return true;
	},
	
	isImage: function(url) {
		var $ending = url.split('.').pop().toLowerCase();
		var $imgFormats = ['png', 'gif', 'jpg', 'jpeg', 'bmp', 'tif', 'eps', 'svg'];
		
		if ($imgFormats.indexOf($ending) != -1) {
			return true;
		}
		
		return false;
	},
	
	preg_quote: function(str, delimiter) {
		return String(str).replace(new RegExp('[.\\\\+*?\\[\\^\\]$(){}=!<>|:\\' + (delimiter || '') + '-]', 'g'), '\\$&');
	}
});
