<?php

namespace wcf\system\worker;

use wcf\data\multirank\Multirank;
use wcf\data\user\User;
use wcf\system\WCF;

/**
 * Multirank rebuild data worker
 *
 * @author        Olaf Braun
 * @copyright     2013-2019 Olaf Braun - Software Development
 * @license       WBB-Elite.de License <https://lizenz.wbb-elite.de/lizenz.html>
 * @package       de.wbb-elite.multirank
 * @category      Several rank graphics
 */
class MultirankRebuildDataWorker extends UserRebuildDataWorker {
	/**
	 * @see    \wcf\system\worker\AbstractWorker::$limit
	 */
	protected $limit = 50;
	/**
	 * all multiranks object
	 *
	 * @var    array<>
	 */
	protected $allMultirank = [];
	
	/**
	 * @inheritdoc
	 */
	public function execute() {
		AbstractRebuildDataWorker::execute();
		$userIDs = [];
		foreach ($this->getObjectList() as $user) {
			$userIDs[] = $user->userID;
		}
		
		if (!empty($userIDs)) {
			foreach (Multirank::getMultiranks() as $multirank) {
				$this->allMultirank[$multirank->multirankID] = $multirank;
			}
			foreach ($userIDs as $userID) {
				$ranks = Multirank::getRanks($userID);
				$rankIDs = [];
				foreach ($ranks as $rank) {
					if ($rank->multirankOption) {
						$rankIDs[] = $rank->rankID;
					}
				}
				$this->updateUserRanks($userID, $rankIDs);
			}
		}
	}
	
	/**
	 * Update user ranks by given multirank ids
	 *
	 * @param         integer $userID
	 * @param         array   $rankIDs
	 *
	 */
	protected function updateUserRanks($userID, $rankIDs) {
		$sql = "UPDATE wcf" . WCF_N . "_user_option_value SET userOption" . User::getUserOptionID("multirankIDs") . " = ? WHERE userID = ?";
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute([implode("\n", $rankIDs), $userID]);
	}
}
