<?php

namespace wcf\system\worker;

use wcf\data\multirank\Multirank;

/**
 * Multirank all user ranks rebuild data worker
 *
 * @author        Olaf Braun
 * @copyright     2013-2019 Olaf Braun - Software Development
 * @license       WBB-Elite.de License <https://lizenz.wbb-elite.de/lizenz.html>
 * @package       de.wbb-elite.multirank
 * @category      Several rank graphics
 */
class MultirankAllRebuildDataWorker extends MultirankRebuildDataWorker {
	/**
	 * @see    \wcf\system\worker\AbstractWorker::$limit
	 */
	protected $limit = 50;
	/**
	 * all multiranks object
	 *
	 * @var    array<>
	 */
	protected $allMultirank = [];
	
	/**
	 * @inheritdoc
	 */
	public function execute() {
		AbstractRebuildDataWorker::execute();
		$userIDs = [];
		foreach ($this->getObjectList() as $user) {
			$userIDs[] = $user->userID;
		}
		
		if (!empty($userIDs)) {
			foreach (Multirank::getMultiranks() as $multirank) {
				$this->allMultirank[$multirank->multirankID] = $multirank;
			}
			foreach ($userIDs as $userID) {
				$ranks = Multirank::getRanks($userID);
				$rankIDs = [];
				foreach ($ranks as $rank) {
					$rankIDs[] = $rank->rankID;
				}
				$this->updateUserRanks($userID, $rankIDs);
			}
		}
	}
	
}
