<?php

namespace wcf\system\multirank;

use wcf\system\WCF;

/**
 * The object type for user profile to append the multirank
 *
 * @author        Olaf Braun
 * @copyright     2013-2019 Olaf Braun - Software Development
 * @license       WBB-Elite.de License <https://lizenz.wbb-elite.de/lizenz.html>
 * @package       de.wbb-elite.multirank
 * @category      Several rank graphics
 */
class MultirankUserProfile implements IMultirank {
	/**
	 * @inheritdoc
	 */
	public function getAppendContainer() {
		return 'h1';
	}
	
	/**
	 * @inheritdoc
	 */
	public function getContainer() {
		return '#tpl_wcf_user .userProfileUser';
	}
	
	/**
	 * @inheritdoc
	 */
	public function getDataUserID() {
		return 'user-id';
	}
	
	/**
	 * @inheritdoc
	 */
	public function getTitle() {
		return WCF::getLanguage()->get("de.wbb-elite.multirank.userProfile");
	}
	
	/**
	 * @inheritdoc
	 */
	public function getUserIDElement() {
		return '.userIDDiv';
	}
}
