<?php

namespace wcf\system\multirank;

use wcf\system\WCF;

/**
 *
 * @author        Olaf Braun
 * @copyright     2013-2019 Olaf Braun - Software Development
 * @license       WBB-Elite.de License <https://lizenz.wbb-elite.de/lizenz.html>
 * @package       de.wbb-elite.multirank
 * @category      Several rank graphics
 */
class MultirankTeamOnline extends MultirankSidebar {
	/**
	 * @inheritdoc
	 */
	public function getAppendContainer() {
		return 'h3';
	}
	
	/**
	 * @inheritdoc
	 */
	public function getContainer() {
		return '.sidebarItemList > li.box32 > .sidebarItemTitle';
	}
	
	/**
	 * @inheritdoc
	 */
	public function getTitle() {
		return WCF::getLanguage()->get("de.wbb-elite.multirank.team.online");
	}
	
	/**
	 * @inheritDoc
	 */
	public function getUserIDElement() {
		return 'h3 > a.userLink';
	}
}
