<?php

namespace wcf\system\multirank;

use wcf\system\WCF;

/**
 * The object type for forum sidebar to append the multirank
 *
 * @author        Olaf Braun
 * @copyright     2013-2019 Olaf Braun - Software Development
 * @license       WBB-Elite.de License <https://lizenz.wbb-elite.de/lizenz.html>
 * @package       de.wbb-elite.multirank
 * @category      Several rank graphics
 */
class MultirankSidebar implements IMultirank {
	/**
	 * @inheritdoc
	 */
	public function getAppendContainer() {
		return '.messageSidebar > div > .messageAuthorContainer';
	}
	
	/**
	 * @inheritdoc
	 */
	public function getContainer() {
		return '.messageList > li > .message';
	}
	
	/**
	 * @inheritdoc
	 */
	public function getDataUserID() {
		return 'user-id';
	}
	
	/**
	 * @inheritdoc
	 */
	public function getTitle() {
		return WCF::getLanguage()->get("de.wbb-elite.multirank.sidebar");
	}
	
	/**
	 * @inheritdoc
	 */
	public function getUserIDElement() {
		return '.messageSidebar > div .messageAuthorContainer > .username.userLink';
	}
}