<?php

namespace wcf\system\multirank;

use wcf\system\WCF;

/**
 * The object type for members list to append the multirank
 *
 * @author        Olaf Braun
 * @copyright     2013-2019 Olaf Braun - Software Development
 * @license       WBB-Elite.de License <https://lizenz.wbb-elite.de/lizenz.html>
 * @package       de.wbb-elite.multirank
 * @category      Several rank graphics
 */
class MultirankMembersList implements IMultirank {
	/**
	 * @inheritdoc
	 */
	public function getAppendContainer() {
		return 'div > div.details  > div.containerHeadline > h3';
	}
	
	/**
	 * @inheritdoc
	 */
	public function getContainer() {
		return '.userList > li';
	}
	
	/**
	 * @inheritdoc
	 */
	public function getDataUserID() {
		return 'object-id';
	}
	
	/**
	 * @inheritdoc
	 */
	public function getTitle() {
		return WCF::getLanguage()->get("de.wbb-elite.multirank.membersList");
	}
	
	/**
	 * @inheritdoc
	 */
	public function getUserIDElement() {
		return '';
	}
}