<?php

namespace wcf\system\multirank;
/**
 * Interface for multriank object
 *
 * @author        Olaf Braun
 * @copyright     2013-2019 Olaf Braun - Software Development
 * @license       WBB-Elite.de License <https://lizenz.wbb-elite.de/lizenz.html>
 * @package       de.wbb-elite.multirank
 * @category      Several rank graphics
 */
interface IMultirank {
	
	/**
	 * Return the container for multirank action
	 *
	 * @return string
	 */
	public function getContainer();
	
	/**
	 * Return the element who contains the user id
	 *
	 * @return string
	 */
	public function getUserIDElement();
	
	/**
	 * Return the data index for the user id
	 *
	 * @return string
	 */
	public function getDataUserID();
	
	/**
	 * Return the container to append or insert the multiranks
	 *
	 * @return string
	 */
	public function getAppendContainer();
	
	/**
	 * Return the title for this multirank object type
	 *
	 * @return string
	 */
	public function getTitle();
}