<?php

namespace wcf\system\event\listener;

use wcf\acp\form\UserRankEditForm;
use wcf\system\WCF;

/**
 * The event list for the user rank add and edit form
 *
 * @author        Olaf Braun
 * @copyright     2013-2019 Olaf Braun - Software Development
 * @license       WBB-Elite.de License <https://lizenz.wbb-elite.de/lizenz.html>
 * @package       de.wbb-elite.multirank
 * @category      Several rank graphics
 */
class UserRankAddMultirankListener implements IParameterizedEventListener {
	
	/**
	 * @inheritdoc
	 */
	public function execute($eventObj, $className, $eventName, array &$parameters) {
		if (MODULE_MULTIRANK) {
			if (!isset($eventObj->additionalFields["multirankOption"])) {
				$eventObj->additionalFields["multirankOption"] = 0;
			}
			if ($eventName == "assignVariables") {
				WCF::getTPL()->assign([
					'multirankOption' => $eventObj->additionalFields["multirankOption"]]);
			} else if ($eventName == "readFormParameters") {
				if (isset($_POST['multirankOption'])) $eventObj->additionalFields["multirankOption"] = 1;
			} else if ($eventName == "validate") {
				if ($eventObj->additionalFields["multirankOption"]) {
					$eventObj->additionalFields["multirankOption"] = 1;
				}
			} else if ($eventName == "readData") {
				if (empty($_POST)) {
					$eventObj->additionalFields["multirankOption"] = 0;
					if ($eventObj instanceof UserRankEditForm) {
						$eventObj->additionalFields["multirankOption"] = $eventObj->rank->multirankOption;
					}
				}
			} else if ($eventName == 'saved') {
				$return = $eventObj->objectAction->getParameters();
				$data = $return["data"];
				if (isset($data["multirankOption"]) && $data["multirankOption"]) {
					$eventObj->additionalFields["multirankOption"] = 1;
				}
			}
		}
	}
}