<?php

namespace wcf\system\event\listener;

use wcf\system\exception\UserInputException;

/**
 * @author        Olaf Braun
 * @copyright     2013-2019 Olaf Braun - Software Development
 * @license       WBB-Elite.de License <https://lizenz.wbb-elite.de/lizenz.html>
 * @package       de.wbb-elite.multirank
 * @category      Several rank graphics
 */
class OptionFormMultirankListener implements IParameterizedEventListener {
	
	/**
	 * @inheritdoc
	 */
	public function execute($eventObj, $className, $eventName, array &$parameters) {
		if ($eventName == "checkModules") {
			if (MODULE_MULTIRANK) {
				$eventObj->neededModules = [];
			}
		} else {
			if (isset($eventObj->optionHandler->optionValues["module_user_rank"]) && isset($eventObj->optionHandler->optionValues["module_multirank"])) {
				$module_user_rank = $eventObj->optionHandler->optionValues["module_user_rank"];
				$module_multi_rank = $eventObj->optionHandler->optionValues["module_multirank"];
				if ($module_user_rank == 1 && $module_multi_rank == 1) {
					throw new UserInputException('options', ['module_user_rank' => 'multirank']);
				}
			}
		}
	}
}
