<?php

namespace wcf\system\event\listener;

use wcf\data\multirank\Multirank;
use wcf\system\WCF;

/**
 * @author        Olaf Braun
 * @copyright     2013-2019 Olaf Braun - Software Development
 * @license       WBB-Elite.de License <https://lizenz.wbb-elite.de/lizenz.html>
 * @package       de.wbb-elite.multirank
 * @category      Several rank graphics
 */
class AddTemplateMultirankListener implements IParameterizedEventListener {
	
	/**
	 * @inheritdoc
	 */
	public function execute($eventObj, $className, $eventName, array &$parameters) {
		if (MODULE_MULTIRANK) {
			$multiranks = Multirank::getMultiranksTemplate();
			WCF::getTPL()->assign(['multiranks' => $multiranks]);
		}
	}
}
