<?php

namespace wcf\system\cache\builder;

use wcf\data\multirank\MultirankList;

/**
 * @author        Olaf Braun
 * @copyright     2013-2019 Olaf Braun - Software Development
 * @license       WBB-Elite.de License <https://lizenz.wbb-elite.de/lizenz.html>
 * @package       de.wbb-elite.multirank
 * @category      Several rank graphics
 */
class MultirankNoParentCacheBuilder extends AbstractCacheBuilder {
	/**
	 * @inheritdoc
	 */
	protected function rebuild(array $parameters) {
		$objectList = new MultirankList();
		$objectList->getConditionBuilder()->add("parentID = 0 OR parentID IS NULL");
		$objectList->sqlOrderBy = " position ASC";
		$objectList->readObjects();
		
		return $objectList->getObjects();
	}
}
