<?php

namespace wcf\acp\page;

use wcf\data\multirank\MultirankList;
use wcf\page\AbstractPage;
use wcf\system\event\EventHandler;
use wcf\system\WCF;

/**
 * @author        Olaf Braun
 * @copyright     2013-2019 Olaf Braun - Software Development
 * @license       WBB-Elite.de License <https://lizenz.wbb-elite.de/lizenz.html>
 * @package       de.wbb-elite.multirank
 * @category      Several rank graphics
 */
class MultirankListPage extends AbstractPage {
	
	/**
	 * @see    \wcf\page\AbstractPage::$activeMenuItem
	 */
	public $activeMenuItem = 'wcf.acp.menu.link.multirank.list';
	
	/**
	 * @see    \wcf\page\AbstractPage::$neededPermissions
	 */
	public $neededPermissions = ['admin.multirank.canMange'];
	/**
	 * @see    \wcf\page\AbstractPage::$neededPermissions
	 */
	public $neededModules = ['MODULE_MULTIRANK'];
	/**
	 * DatabaseObjectList object
	 *
	 * @var    \wcf\data\DatabaseObjectList
	 */
	public $objectList = null;
	
	/**
	 * @see    \wcf\page\IPage::assignVariables()
	 */
	public function assignVariables() {
		parent::assignVariables();
		
		// assign page parameters
		WCF::getTPL()->assign([
			'objects' => $this->objectList
		]);
	}
	
	/**
	 * @see    \wcf\page\IPage::readData()
	 */
	public function readData() {
		parent::readData();
		
		// initialize database object list
		$this->initObjectList();
	}
	
	/**
	 * @see    \wcf\page\MultipleLinkPage::initObjectList()
	 */
	protected function initObjectList() {
		$this->objectList = new MultirankList();
		$this->objectList->sqlOrderBy = "multirank.position ASC";
		$this->objectList->getConditionBuilder()->add("(parentID = 0 OR parentID IS NULL)");
		EventHandler::getInstance()->fireAction($this, 'beforeReadObjects');
		$this->objectList->readObjects();
	}
}
