<?php

namespace wcf\acp\form;

use wcf\data\multirank\Multirank;
use wcf\data\multirank\MultirankAction;
use wcf\data\package\PackageCache;
use wcf\form\AbstractForm;
use wcf\system\exception\IllegalLinkException;
use wcf\system\language\I18nHandler;
use wcf\system\WCF;

/**
 * Multirank edit form class
 *
 * @author        Olaf Braun
 * @copyright     2013-2019 Olaf Braun - Software Development
 * @license       WBB-Elite.de License <https://lizenz.wbb-elite.de/lizenz.html>
 * @package       de.wbb-elite.multirank
 * @category      Several rank graphics
 */
class MultirankEditForm extends MultirankAddForm {
	
	/**
	 * @see    \wcf\page\AbstractPage::$templateName
	 */
	public $templateName = 'multirankAdd';
	/**
	 * @see    \wcf\page\AbstractPage::$activeMenuItem
	 */
	public $activeMenuItem = 'wcf.acp.menu.link.multirank';
	
	/**
	 * Multirank object
	 *
	 * @var    integer
	 */
	public $multirankID = 0;
	/**
	 * Multirank object
	 *
	 * @var    \wcf\data\multirank\Multirank
	 */
	public $multirank = null;
	
	/**
	 * @inheritdoc
	 */
	public function assignVariables() {
		parent::assignVariables();
		$useRequestData = (empty ($_POST)) ? false : true;
		I18nHandler::getInstance()->assignVariables($useRequestData);
		WCF::getTPL()->assign(['action'      => 'edit',
		                       'multirankID' => $this->multirankID]);
	}
	
	/**
	 * @inheritdoc
	 */
	public function readData() {
		parent::readData();
		
		if (empty($_POST)) {
			I18nHandler::getInstance()->setOptions('title', PackageCache::getInstance()->getPackageID('com.woltlab.wcf'), $this->multirank->title, 'de.wbb-elite.multirank.\d+.title');
			$this->title = $this->multirank->title;
			$this->parentID = $this->multirank->parentID;
			$this->position = $this->multirank->position;
			$this->objectTypeID = $this->multirank->objectTypeID;
			$this->max = $this->multirank->max;
			$this->type = $this->multirank->type;
			$this->css = $this->multirank->css;
		}
	}
	
	/**
	 * @inheritdoc
	 */
	public function readParameters() {
		parent::readParameters();
		if (isset($_REQUEST['id'])) {
			$this->multirankID = intval($_REQUEST['id']);
		}
		$this->multirank = new Multirank($this->multirankID);
		if (!$this->multirank->multirankID) {
			throw new IllegalLinkException();
		}
		
		foreach ($this->parents as $id => $parent) {
			if ($parent->multirankID == $this->multirank->multirankID) {
				unset($this->parents[$id]);
			}
		}
	}
	
	/**
	 * @see    \wcf\form\IForm::save()
	 */
	
	public function save() {
		AbstractForm::save();
		$this->title = 'de.wbb-elite.multirank.' . $this->multirank->multirankID . '.title';
		if (I18nHandler::getInstance()->isPlainValue('title')) {
			I18nHandler::getInstance()->remove($this->title);
			$this->title = I18nHandler::getInstance()->getValue('title');
		} else {
			I18nHandler::getInstance()->save('title', $this->title, 'de.wbb-elite.multirank', PackageCache::getInstance()->getPackageID('com.woltlab.wcf'));
		}
		$this->objectAction = new MultirankAction([$this->multirank], 'update', ['data' => ['title'        => $this->title,
		                                                                                    'css'          => $this->css,
		                                                                                    'objectTypeID' => $this->objectTypeID,
		                                                                                    'parentID'     => $this->parentID,
		                                                                                    'max'          => $this->max,
		                                                                                    'position'     => $this->position,
		                                                                                    'type'         => $this->type]]);
		$this->objectAction->executeAction();
		$this->saved();
		WCF::getTPL()->assign(['success' => true]);
	}
}
