<?php

use wcf\data\multirank\MultirankAction;
use wcf\system\multirank\MultirankHandler;

/**
 *
 */

$multiLang = false;
if (count(\wcf\system\language\LanguageFactory::getInstance()->getLanguages()) > 1) $multiLang = true;
//add sidebar entry
$objectType = MultirankHandler::getInstance()->getObjectTypeByName("de.wbb-elite.multirank.sidebar");
$title = "Sidebar";
if ($multiLang) $title = "de.wbb-elite.multirank.1.title";
$returnValues = addItem($title, 1, 0, 0, $objectType->getObjectID(), '', 2);

//add sidebar entry for board
$objectType = MultirankHandler::getInstance()->getObjectTypeByName("de.wbb-elite.multirank.sidebar.board");
$title = "Sidebar Forum";
if ($multiLang) $title = "de.wbb-elite.multirank.2.title";
$object = $returnValues['returnValues'];
$returnValues = addItem($title, 0, $object->multirankID, 0, $objectType->getObjectID(), '', 2);

//add members list entry
$objectType = MultirankHandler::getInstance()->getObjectTypeByName("de.wbb-elite.multirank.memberslist");
$title = "Mitgliederliste";
if ($multiLang) $title = "de.wbb-elite.multirank.3.title";
$returnValues = addItem($title, 2, 0, 1, $objectType->getObjectID(), 'display:inline-block;', 1);

//add members list entry
$objectType = MultirankHandler::getInstance()->getObjectTypeByName("de.wbb-elite.multirank.userpopup");
$title = "PopUp Fenster";
if ($multiLang) $title = "de.wbb-elite.multirank.4.title";
$object = $returnValues['returnValues'];
$returnValues = addItem($title, 1, $object->multirankID, 1, $objectType->getObjectID(), 'display:inline-block;', 1);

//user profile entry
$objectType = MultirankHandler::getInstance()->getObjectTypeByName("de.wbb-elite.multirank.userprofile");
$title = "Userprofile";
if ($multiLang) $title = "de.wbb-elite.multirank.5.title";
$returnValues = addItem($title, 3, 0, 0, $objectType->getObjectID(), 'display:block;', 2);


/**
 * Create a new multirank object
 *
 * @param string  $title
 * @param integer $position
 * @param integer $parentID
 * @param integer $max
 * @param integer $objectTypeID
 * @param string  $css
 * @param integer $type
 *
 * @return array
 */
function addItem($title, $position, $parentID, $max, $objectTypeID, $css, $type) {
	$objectAction = new MultirankAction([], 'create', ['data' => ['title'        => $title,
	                                                              'position'     => $position,
	                                                              'parentID'     => $parentID,
	                                                              'max'          => $max,
	                                                              'objectTypeID' => $objectTypeID,
	                                                              'css'          => $css,
	                                                              'type'         => $type]]);
	
	return $objectAction->executeAction();
}