{include file='header' pageTitle='de.wbb-elite.multirank.acp.list'}

<script data-relocate="true">
    $(function () {
        new WCF.Action.NestedDelete('wcf\\data\\multirank\\MultirankAction', '.jsCategory');
        new WCF.Action.Toggle('wcf\\data\\multirank\\MultirankAction', '.jsCategory', '> .sortableNodeLabel > .buttons > .jsToggleButton');

        var sortableNodes = $('.sortableNode');
        sortableNodes.each(function (index, node) {
            $(node).wcfIdentify();
        });

        require(['WoltLabSuite/Core/Ui/Sortable/List'], function (UiSortableList) {
            new UiSortableList({
                containerId: 'categoryList',
                className: 'wcf\\data\\multirank\\MultirankAction',
                options: {
                    /**
                     * Updates the sortable nodes after a sorting is started with
                     * regard to their possibility to have child the currently sorted
                     * category as a child category.
                     */
                    start: function (event, ui) {
                        var sortedListItem = $(ui.item);
                        var itemNestingLevel = sortedListItem.find('.sortableList:has(.sortableNode)').length;

                        sortableNodes.each(function (index, node) {
                            node = $(node);

                            if (node.attr('id') != sortedListItem.attr('id')) {
                                if (node.parents('.sortableList').length + itemNestingLevel >= 2) {
                                    node.addClass('sortableNoNesting');
                                }
                                else if (node.hasClass('sortableNoNesting')) {
                                    node.removeClass('sortableNoNesting');
                                }
                            }
                        });
                    },

                    /**
                     * Updates the sortable nodes after a sorting is completed with
                     * regard to their possibility to have child categories.
                     */
                    stop: function (event, ui) {
                        sortableNodes.each(function (index, node) {
                            node = $(node);

                            if (node.parents('.sortableList').length == 2) {
                                node.addClass('sortableNoNesting');
                            }
                            else if (node.hasClass('sortableNoNesting')) {
                                node.removeClass('sortableNoNesting');
                            }
                        });
                    }
                }
            });
        });
    });
</script>

<header class="contentHeader">
	<div class="contentHeaderTitle">
		<h1 class="contentTitle">{lang}de.wbb-elite.multirank.acp.list{/lang}</h1>
	</div>

	{hascontent}
		<nav class="contentHeaderNavigation">
			<ul>
				{content}
					<li><a href="{link controller='MultirankAdd'}{/link}" class="button"><span
									class="icon icon16 fa-plus"></span>
							<span>{lang}wcf.acp.menu.link.multirank.add{/lang}</span></a></li>
				{event name='contentHeaderNavigation'}
				{/content}
			</ul>
		</nav>
	{/hascontent}
</header>
{hascontent}
	<div id="categoryList"
	     class="section sortableListContainer">
		<ol class="sortableList" data-object-id="0">
			{content}
			{foreach from=$objects item='multirank'}
				<li class="sortableNode jsCategory" data-object-id="{@$multirank->multirankID}" data-is-open="1">
                    <span class="sortableNodeLabel">
                        <a href="{link controller=MultirankEdit id=$multirank->multirankID}{/link}">{lang}{$multirank->title}{/lang}</a>
                        <span class="statusDisplay sortableButtonContainer">
                           <a href="{link controller=MultirankEdit id=$multirank->multirankID}{/link}" class="jsTooltip"
                              title="{lang}wcf.global.button.edit{/lang}"><span
			                           class="icon icon16 fa-pencil"></span></a>
                        	<span class="icon icon16 fa-remove jsDeleteButton jsTooltip pointer"
	                              title="{lang}wcf.global.button.delete{/lang}"
	                              data-object-id="{@$multirank->multirankID}"
	                              data-confirm-message="{lang}de.wbb-elite.multirank.acp.delete.sure{/lang}"></span>
						</span>
                     </span>
					<ol class="sortableList" data-object-id="{@$multirank->multirankID}">
						{assign var="parents" value=$multirank->getParentMultiranks()}
						{if $parents|count > 0}
							{foreach from=$parents item='parent'}
								<li class="sortableNode jsCategory" data-object-id="{@$parent->multirankID}"
								    data-is-open="1">
                                        <span class="sortableNodeLabel">
                                            <a href="{link controller=MultirankEdit id=$parent->multirankID}{/link}">{lang}{$parent->title}{/lang}</a>
                                            <span class="statusDisplay sortableButtonContainer">
                                                <a href="{link controller=MultirankEdit id=$parent->multirankID}{/link}"
                                                   class="jsTooltip"
                                                   title="{lang}wcf.global.button.edit{/lang}"><span
			                                                class="icon icon16 fa-pencil"></span></a>
                                            	<span class="icon icon16 fa-remove jsDeleteButton jsTooltip pointer"
	                                                  title="{lang}wcf.global.button.delete{/lang}"
	                                                  data-object-id="{@$multirank->multirankID}"
	                                                  data-confirm-message="{lang}de.wbb-elite.multirank.acp.delete.sure{/lang}"></span>
						                    </span>
                                         </span>
								</li>
							{/foreach}
						{/if}
					</ol>
				</li>
			{/foreach}
			{/content}
		</ol>
	</div>
	<div class="formSubmit">
		<button class="button" data-type="submit">{lang}wcf.global.button.saveSorting{/lang}</button>
	</div>
{hascontentelse}
	<p class="info">{lang}wcf.global.noItems{/lang}</p>
{/hascontent}

{include file='footer'}
