{include file='header' pageTitle='de.wbb-elite.multirank.acp.'|concat:$action}
{include file='multipleLanguageInputJavascript' elementIdentifier='title' forceSelection=false}

<header class="contentHeader">
	<div class="contentHeaderTitle">
		<h1 class="contentTitle">{lang}de.wbb-elite.multirank.acp.{$action}{/lang}</h1>
	</div>

	{hascontent}
		<nav class="contentHeaderNavigation">
			<ul>
				{content}
					<li><a href="{link controller='MultirankList'}{/link}" class="button"><span
									class="icon icon16 fa-list"></span>
							<span>{lang}wcf.acp.menu.link.multirank.list{/lang}</span></a></li>
				{event name='contentHeaderNavigation'}
				{/content}
			</ul>
		</nav>
	{/hascontent}
</header>

{include file='formError'}
{if $success|isset}
	<p class="success">{lang}wcf.global.success.{@$action}{/lang}</p>
{/if}

<form method="post"
      action="{if $action == 'add'}{link controller='MultirankAdd'}{/link}{else}{link controller='MultirankEdit' id=$multirankID}{/link}{/if}">
	<div class="section">
		<h2 class="sectionTitle">{lang}de.wbb-elite.multirank.general{/lang}</h2>
		<dl{if $errorField == 'title'} class="formError"{/if}>
			<dt><label for="title">{lang}wcf.global.title{/lang}</label></dt>
			<dd>
				<input type="text" id="title" name="title" value="{$title}" autofocus="autofocus" class="medium"/>
				<small>{lang}de.wbb-elite.multirank.title.description{/lang}</small>
				{if $errorField == 'title'}
					<small class="innerError">
						{if $errorType == 'empty'}
							{lang}wcf.global.form.error.empty{/lang}
						{/if}
					</small>
				{/if}
			</dd>
		</dl>
		{if $parents|count > 0}
			<dl{if $errorField == 'parentID'} class="formError"{/if}>
				<dt><label for="parentID">{lang}de.wbb-elite.multirank.acp.parentID{/lang}</label></dt>
				<dd>
					<select id="parentID" name="parentID">
						<option value="0">{lang}wcf.global.noSelection{/lang}</option>
						{foreach from=$parents item=parent}
							<option value="{@$parent->multirankID}"{if $parent->multirankID == $parentID} selected="selected"{/if}>{lang}{$parent->title}{/lang}</option>
						{/foreach}
					</select>
					{if $errorField == 'parentID'}
						<small class="innerError">
							{if $errorType == 'empty'}
								{lang}wcf.global.form.error.empty{/lang}
							{else}
								{lang}de.wbb-elite.multirank.acp.error.{$errorType}{/lang}
							{/if}
						</small>
					{/if}
				</dd>
			</dl>
		{/if}
		<dl{if $errorField == 'position'} class="formError"{/if}>
			<dt><label for="position">{lang}de.wbb-elite.multirank.acp.position{/lang}</label></dt>
			<dd>
				<input type="number" id="position" name="position" value="{$position}" min="0" class="tiny"/>
				{if $errorField == 'position'}
					<small class="innerError">
						{if $errorType == 'empty'}
							{lang}wcf.global.form.error.empty{/lang}
						{/if}
					</small>
				{/if}
			</dd>
		</dl>
		<h2 class="sectionTitle">{lang}de.wbb-elite.multirank.acp.settings{/lang}</h2>
		<dl{if $errorField == 'objectTypeID'} class="formError"{/if}>
			<dt><label for="objectTypeID">{lang}de.wbb-elite.multirank.objectTypeID{/lang}</label></dt>
			<dd>
				<select name="objectTypeID" id="objectTypeID">
					{foreach from=$objectTypes item="multirankObject"}
						<option value="{@$multirankObject->objectTypeID}"{if $multirankObject->objectTypeID == $objectTypeID} selected="selected"{/if}>{@$multirankObject->getProcessor()->getTitle()}</option>
					{/foreach}
				</select>
				{if $errorField == 'objectTypeID'}
					<small class="innerError">
						{if $errorType == 'empty'}
							{lang}wcf.global.form.error.empty{/lang}
						{/if}
					</small>
				{/if}
			</dd>
		</dl>
		<dl{if $errorField == 'type'} class="formError"{/if}>
			<dt><label for="type">{lang}de.wbb-elite.multirank.acp.type{/lang}</label></dt>
			<dd>
				<label><input type="radio" value="0"
				              name="type"{if $type == 0} checked="checked"{/if}/>{lang}de.wbb-elite.multirank.acp.type.befor{/lang}
				</label>
				<label><input type="radio" value="1"
				              name="type"{if $type == 1} checked="checked"{/if}/>{lang}de.wbb-elite.multirank.acp.type.insert{/lang}
				</label>
				<label><input type="radio" value="2"
				              name="type"{if $type == 2} checked="checked"{/if}/>{lang}de.wbb-elite.multirank.acp.type.after{/lang}
				</label>
				<small>{lang}de.wbb-elite.multirank.type.description{/lang}</small>
				{if $errorField == 'type'}
					<small class="innerError">
						{if $errorType == 'empty'}
							{lang}wcf.global.form.error.empty{/lang}
						{/if}
					</small>
				{/if}
			</dd>
		</dl>
		<h2 class="sectionTitle">{lang}de.wbb-elite.multirank.acp.spezial{/lang}</h2>
		<dl{if $errorField == 'css'} class="formError"{/if}>
			<dt><label for="css">{lang}de.wbb-elite.multirank.acp.css{/lang}</label></dt>
			<dd>
				<input type="text" name="css" id="css" value="{$css}" autofocus="autofocus" class="long"/>
				<small>{lang}de.wbb-elite.multirank.acp.css.description{/lang}</small>
				{if $errorField == 'css'}
					<small class="innerError">
						{if $errorType == 'empty'}
							{lang}wcf.global.form.error.empty{/lang}
						{/if}
					</small>
				{/if}
			</dd>
		</dl>
		<dl{if $errorField == 'max'} class="formError"{/if}>
			<dt><label for="max">{lang}de.wbb-elite.multirank.acp.max{/lang}</label></dt>
			<dd>
				<input type="number" id="max" name="max" value="{$max}" min="0" class="tiny"/>
				<small>{lang}de.wbb-elite.multirank.acp.max.description{/lang}</small>
				{if $errorField == 'max'}
					<small class="innerError">
						{if $errorType == 'empty'}
							{lang}wcf.global.form.error.empty{/lang}
						{/if}
					</small>
				{/if}
			</dd>
		</dl>
		{event name='fieldsets'}
	</div>
	<div class="formSubmit">
		<input type="submit" value="{lang}wcf.global.button.submit{/lang}" accesskey="s"/>
		{@SECURITY_TOKEN_INPUT_TAG}
	</div>
</form>

{include file='footer'}