{include file='header' pageTitle='wcf.acp.group.rights.copy'}

<script data-relocate="true">
	//<![CDATA[
	$(function() {	
		WCF.TabMenu.init();
	
		// fieldset-fix for broken firefox
		if ($.browser.mozilla) {
			$('#general').find('fieldset').css('display', 'block');
		}		
	});
	//]]>
</script>

<header class="boxHeadline">
	<h1>{lang}wcf.acp.group.rights.copy{/lang}</h1>
</header>

{include file='formError'}

{if $success|isset}
	<p class="success">{lang}wcf.global.success{/lang}</p>
{/if}

<form method="post" action="{link controller='GroupRightsCopy'}{/link}">
	<div class="tabMenuContainer" data-active="{$activeTabMenuItem}" data-store="activeTabMenuItem">
		<nav class="tabMenu">
			<ul>
				<li><a href="{@$__wcf->getAnchor('general')}">{lang}wcf.acp.option.category.general{/lang}</a></li>
				{event name='tabMenuTabs'}
			</ul>
		</nav>
		
		<div id="general" class="container containerPadding tabMenuContent">				
			<fieldset>				
				{hascontent}
					<dl{if $errorField == 'sourceGroupID'} class="formError"{/if}>
						<dt><label for="sourceGroupID">{lang}wcf.acp.group.sourceGroupID{/lang}</label></dt>
						<dd>
							<select name="sourceGroupID" id="sourceGroupID">
								{content}
									{foreach from=$groupList item=groupNode}
											<option value="{@$groupNode->groupID}"{if $groupNode->groupID == $sourceGroupID} selected="selected"{/if}>{$groupNode->groupName|language}</option>
									{/foreach}
								{/content}
							</select>
							{if $errorField == 'sourceGroupID'}
								<small class="innerError">
									{lang}wcf.acp.group.sourceGroupID.error.{@$errorType}{/lang}
								</small>
							{/if}
						</dd>
					</dl>
				{/hascontent}
						
				{hascontent}
					<dl {if $errorField == 'targetGroupIDs'} class="formError"{/if}>
					    <dt><label for="targetGroupIDs">{lang}wcf.acp.group.targetGroupIDs{/lang}</label></dt>
					    <dd>
					        <select id="targetGroupIDs" name="targetGroupIDs[]" multiple="multiple" size="10">
					        	{content}			            
						            {foreach from=$groupList item=groupNode}
						                <option value="{@$groupNode->groupID}">{$groupNode->groupName|language}</option>
						            {/foreach}
								{/content}
					        </select>
					        <small>{lang}wcf.global.multiSelect{/lang}</small>
							{if $errorField == 'targetGroupIDs'}
								<small class="innerError">
									{lang}wcf.acp.group.targetGroupIDs.error.{@$errorType}{/lang}
								</small>
							{/if}
					    </dd>
					</dl>
				{/hascontent}
			</fieldset>
			
			{event name='generalFieldsets'}
		</div>
		
		{event name='tabMenuContents'}
	</div>
	
	<div class="formSubmit">
		<input type="submit" value="{lang}wcf.acp.group.copy{/lang}" accesskey="s" />
		{@SECURITY_TOKEN_INPUT_TAG}
	</div>
</form>

{include file='footer'}