<?php

/*
 * Copyright by SoftCreatR Media.
 *
 * License: https://www.softcreatr.com/license-terms
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 *
 * The above copyright notice and this disclaimer notice shall be included in all
 * copies or substantial portions of the Software.
 */

namespace wcf\system\box;

use wcf\system\WCF;
use wcf\util\DateUtil;

use function date;
use function mktime;
use function strtotime;

class AdventWreathBoxController extends AbstractBoxController
{
    /**
     * @inheritDoc
     */
    protected static $supportedPositions = ['sidebarLeft', 'sidebarRight'];

    /**
     * @inheritDoc
     */
    protected function loadContent()
    {
        if (!MODULE_ADVENT_WREATH) {
            return;
        }

        /*
         * We'll perform most logic using PHP instead of JS, because
         * it's somewhat cleaner and easier to understand.
         *
         * @see https://support.softcreatr.com/thread/1831
         */
        $now = new \DateTime();
        $currentAdventWeek = 0;
        $weekDay = (int)DateUtil::format($now, 'w');
        $adventDays = [
            DateUtil::getDateTimeByTimestamp(strtotime("+1 sunday", gmmktime(0, 0, 0, 11, 27))),
            DateUtil::getDateTimeByTimestamp(strtotime("+2 sunday", gmmktime(0, 0, 0, 11, 27))),
            DateUtil::getDateTimeByTimestamp(strtotime("+3 sunday", gmmktime(0, 0, 0, 11, 27))),
            DateUtil::getDateTimeByTimestamp(strtotime("+4 sunday", gmmktime(0, 0, 0, 11, 27)))
        ];

        for ($i = 0 ; $i < 4; $i++) {
            if ($now < DateUtil::getDateTimeByTimestamp(gmmktime(0, 0, 0, 12, 25)) && $now >= $adventDays[$i]) {
                $currentAdventWeek = $i + 1;
            }
        }

        if (!ADVENT_WREATH_DISPLAY_ALWAYS && $currentAdventWeek === 0) {
            return;
        }

        if ($currentAdventWeek > 0) {
            $boxTitle = str_replace('%d', $currentAdventWeek, WCF::getLanguage()->get(ADVENT_WREATH_TITLE));
        } else {
            $boxTitle = '';
        }

        $this->content = WCF::getTPL()->fetch('boxAdventWreath', 'wcf', [
            'boxTitle' => $boxTitle,
            'currentAdventWeek' => $currentAdventWeek,
            'today' => $weekDay + 1
        ], true);
    }
}
