{include file='header' pageTitle='wcf.acp.menu.link.user.effectiveUserPermissions'}

<script data-relocate="true">
    require(['WoltLabSuite/Core/Ui/User/Search/Input'], function(UiUserSearchInput) {
	    new UiUserSearchInput(elBySel('input[name="username"]'));
    });
</script>

<header class="contentHeader">
	<div class="contentHeaderTitle">
		<h1 class="contentTitle">{lang}wcf.acp.menu.link.user.effectiveUserPermissions{/lang}</h1>
	</div>
</header>

<form method="post" action="{link controller='EffectiveUserPermissionView'}{/link}">
	<section class="section">
		<h2 class="sectionTitle">{lang}wcf.global.filter{/lang}</h2>

		<div class="row rowColGap formGrid">
			<dl class="col-xs-12 col-md-6">
				<dt></dt>
				<dd>
					<input type="text" id="username" name="username" value="{$username}" placeholder="{lang}wcf.user.username{/lang}" class="long">
				</dd>
			</dl>
		</div>
	</section>

	<div class="formSubmit">
		<input type="submit" value="{lang}wcf.global.button.submit{/lang}" accesskey="s">
		{@SECURITY_TOKEN_INPUT_TAG}
	</div>
</form>

{if !$optionTree|empty}
	<div class="section tabMenuContainer">
		<nav class="tabMenu">
			<ul>
				{foreach from=$optionTree item=categoryLevel1}
					<li><a href="{@$__wcf->getAnchor($categoryLevel1[object]->categoryName)}">{lang}wcf.acp.group.option.category.{@$categoryLevel1[object]->categoryName}{/lang}</a></li>
				{/foreach}
			</ul>
		</nav>

		{foreach from=$optionTree item=categoryLevel1}
			<div id="{@$categoryLevel1[object]->categoryName}" class="tabMenuContainer tabMenuContent">
				<nav class="menu">
					<ul>
						{foreach from=$categoryLevel1[categories] item=$categoryLevel2}
							{assign var=__categoryLevel2Name value=$categoryLevel1[object]->categoryName|concat:'-':$categoryLevel2[object]->categoryName}
							<li><a href="{@$__wcf->getAnchor($__categoryLevel2Name)}">{lang}wcf.acp.group.option.category.{@$categoryLevel2[object]->categoryName}{/lang}</a></li>
						{/foreach}
					</ul>
				</nav>

				{foreach from=$categoryLevel1[categories] item=categoryLevel2}
					<div id="{@$categoryLevel1[object]->categoryName}-{@$categoryLevel2[object]->categoryName}" class="tabMenuContent hidden">
						{if $categoryLevel2[options]|count}
							<div class="section">
								{include file='effectiveOptionFieldList' options=$categoryLevel2[options] langPrefix='wcf.acp.group.option.' isGuestGroup=false}
							</div>
						{/if}

						{if $categoryLevel2[categories]|count}
							{foreach from=$categoryLevel2[categories] item=categoryLevel3}
								<section class="section">
									<header class="sectionHeader">
										<h2 class="sectionTitle">{lang}wcf.acp.group.option.category.{@$categoryLevel3[object]->categoryName}{/lang}</h2>
										{hascontent}<p class="sectionDescription">{content}{lang __optional=true}wcf.acp.group.option.category.{@$categoryLevel3[object]->categoryName}.description{/lang}{/content}</p>{/hascontent}
									</header>

									{include file='effectiveOptionFieldList' options=$categoryLevel3[options] langPrefix='wcf.acp.group.option.' isGuestGroup=false}
								</section>
							{/foreach}
						{/if}
					</div>
				{/foreach}
			</div>
		{/foreach}
	</div>
{else}
	<p class="info">{lang}wcf.acp.user.effectivePermissions.noUserSelected{/lang}</p>
{/if}

{include file='footer'}
