<?php
namespace wcf\system\event\listener;
use wcf\system\WCF;

/**
 * Reads the userID from the request and submit it to the template engine.
 *
 * @author	Fabian Gossner
 * @copyright 	2018 Fabian Gossner
 * @license	Creative Commons Attribution-NonCommercial-ShareAlike <http://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>
 */
class FabiiUserGroupOptionFormListener implements IParameterizedEventListener {
	/**
	 * @var integer
	 */
	protected $userID = 0;
	
	/**
	 * @inheritDoc
	 */
	public function execute($eventObj, $className, $eventName, array &$parameters) {
		if (method_exists($this, $eventName) && $eventName !== 'execute') {
			$this->$eventName($eventObj);
		}
		else {
			throw new \LogicException('Unreachable');
		}
	}
	
	/**
	 * @see	IForm::readParameters()
	 */
	protected function readParameters() {
		if (isset($_REQUEST['userID'])) $this->userID = intval($_REQUEST['userID']);
	}
	
	/**
	 * @see	IForm::readFormParameters()
	 */
	protected function readFormParameters() {
		if (isset($_REQUEST['userID'])) $this->userID = intval($_REQUEST['userID']);
	}
	
	/**
	 * @see	IPage::assignVariables()
	 */
	protected function assignVariables() {
		WCF::getTPL()->assign('userID', $this->userID);
	}
}
