<?php
namespace wcf\acp\page;
use wcf\data\user\User;
use wcf\page\AbstractPage;
use wcf\system\option\user\group\EffectiveUserGroupOptionHandler;
use wcf\system\WCF;
use wcf\util\StringUtil;

/**
 * Shows the effective user permissions of a certain user.
 *
 * @author	Fabian Gossner
 * @copyright 	2018 Fabian Gossner
 * @license	Creative Commons Attribution-NonCommercial-ShareAlike <http://creativecommons.org/licenses/by-nc-sa/4.0/legalcode>
 */
class EffectiveUserPermissionViewPage extends AbstractPage {
	/**
	 * @inheritDoc
	 */
	public $activeMenuItem = 'wcf.acp.menu.link.user.effectiveUserPermissions';
	
	/**
	 * @inheritDoc
	 */
	public $neededPermissions = ['admin.user.canEditGroup'];
	
	/**
	 * @var User
	 */
	public $user;
	
	/**
	 * @var string
	 */
	public $username = '';
	
	/**
	 * option tree
	 * @var	array
	 */
	public $optionTree = [];
	
	/**
	 * @inheritDoc
	 */
	public function readParameters() {
		parent::readParameters();
		
		if (!empty($_REQUEST['username'])) $this->username = StringUtil::trim($_REQUEST['username']);
		
		if (!empty($this->username)) {
			$this->user = User::getUserByUsername($this->username);
		}
		else {
			// fallback to userID if no username is present
			if (!empty($_REQUEST['userID'])) {
				$this->user = new User(intval($_REQUEST['userID']));
				$this->username = $this->user->username ?: '';
			}
		}
		
		if ($this->user === null || !$this->user->userID) return;
		
		$optionHandler = new EffectiveUserGroupOptionHandler(true);
		$optionHandler->setUser($this->user);
		$this->optionTree = $optionHandler->getOptionTree();
	}
        
        /**
         * @inheritDoc
         */
        public function assignVariables() {
                parent::assignVariables();
                
                WCF::getTPL()->assign([
                        'optionTree' => $this->optionTree,
			'username' => $this->username,
			'user' => $this->user
                ]);
        }
}
