{capture assign='pageTitle'}{lang}wcf.user.moderatedUserGroups.members{/lang} - {$group->groupName|language}{/capture}

{capture assign='contentHeader'}
	<header class="contentHeader">
		<div class="contentHeaderTitle">
			<h1 class="contentTitle">{$group->groupName|language}: {lang}wcf.user.moderatedUserGroups.members{/lang} <span class="badge">{#$items}</span></h1>
		</div>
		
		{hascontent}
			<nav class="contentHeaderNavigation">
				<ul>
					{content}
						{if $group->groupType == 6 || $group->groupType == 7}
							<li><a href="{link controller='UserGroupManageApplicationList' id=$group->groupID}{/link}" class="button"><span class="icon icon16 fa-list"></span> <span>{lang}wcf.user.moderatedUserGroups.applications{/lang}</span></a></li>
						{/if}
						{event name='contentHeaderNavigation'}
					{/content}
				</ul>
			</nav>
		{/hascontent}
	</header>
{/capture}

{include file='userMenuSidebar'}

{include file='header' __disableAds=true __sidebarLeftHasMenu=true}

<form method="post" class="jsOnly" id="addMembersForm">
	<section class="section">
		<h2 class="sectionTitle">{lang}wcf.user.moderatedUserGroups.members.add{/lang}</h2>
		
		<dl>
			<dt><label for="username">{lang}wcf.user.username{/lang}</label></dt>
			<dd>
				<input type="text" id="username" name="username" value="" class="medium">
				<small>{lang}wcf.user.moderatedUserGroups.members.add.description{/lang}</small>
			</dd>
		</dl>
	</section>
	
	{event name='sections'}
</form>

{hascontent}
	<div class="paginationTop">
		{content}
			{pages print=true assign=pagesLinks controller="UserGroupManageMemberList" id=$group->groupID link="pageNo=%d&sortField=$sortField&sortOrder=$sortOrder"}
		{/content}
	</div>
{/hascontent}

{if $items}
	<div class="section sectionContainerList">
		<ol class="containerList userList">
			{foreach from=$objects item=user}
				<li>
					<div class="box48">
						<a href="{link controller='User' object=$user}{/link}" title="{$user->username}">{@$user->getAvatar()->getImageTag(48)}</a>
							
						<div class="details userInformation">
							{include file='userInformationHeadline'}
							
							<nav class="jsMobileNavigation buttonGroupNavigation">
								<ul class="buttonList">
									<li><a href="{link controller='UserGroupManageKickMember' id=$group->groupID}memberID={@$user->userID}&t={@SECURITY_TOKEN}{/link}" title="{lang}wcf.user.moderatedUserGroups.members.kick{/lang}" class="jsTooltip" onclick="WCF.System.Confirmation.show('{lang __encode=true}wcf.user.moderatedUserGroups.members.kick.sure{/lang}', $.proxy(function (action) { if (action == 'confirm') window.location.href = $(this).attr('href'); }, this), undefined, undefined, true); return false;"><span class="icon icon16 fa-times"></span></a></li>
									{event name='userButtons'}
								</ul>
							</nav>
							
							<dl class="plain inlineDataList small">
								{include file='userInformationStatistics'}
							</dl>
						</div>
					</div>
				</li>
			{/foreach}
		</ol>
	</div>
	
	<footer class="contentFooter">
		{hascontent}
			<div class="paginationBottom">
				{content}{@$pagesLinks}{/content}
			</div>
		{/hascontent}
		
		{hascontent}
			<nav class="contentFooterNavigation">
				<ul>
					{content}
						{if $group->groupType == 6 || $group->groupType == 7}
							<li><a href="{link controller='UserGroupManageApplicationList' id=$group->groupID}{/link}" class="button"><span class="icon icon16 fa-list"></span> <span>{lang}wcf.user.moderatedUserGroups.applications{/lang}</span></a></li>
						{/if}
						{event name='contentFooterNavigation'}
					{/content}
				</ul>
			</nav>
		{/hascontent}
	</footer>
{/if}

<script data-relocate="true" src="{@$__wcf->getPath()}js/WCF.ModeratedUserGroup{if !ENABLE_DEBUG_MODE}.min{/if}.js?v={@LAST_UPDATE_TIME}"></script>
<script data-relocate="true">
	$(function() {
		WCF.Language.addObject({
			'wcf.user.moderatedUserGroups.members.add.success': '{lang}wcf.user.moderatedUserGroups.members.add.success{/lang}',
			'wcf.user.moderatedUserGroups.members.add.error.notFound': '{lang}wcf.user.moderatedUserGroups.members.add.error.notFound{/lang}',
			'wcf.user.moderatedUserGroups.members.add.error.alreadyMember': '{lang}wcf.user.moderatedUserGroups.members.add.error.alreadyMember{/lang}'
		});
		
		new WCF.ModeratedUserGroup.AddMembers({@$group->groupID});
	});
</script>

{include file='footer'}
