{capture assign='pageTitle'}{lang}wcf.user.moderatedUserGroups.applications{/lang} - {$group->groupName|language}{/capture}

{capture assign='contentHeader'}
	<header class="contentHeader">
		<div class="contentHeaderTitle">
			<h1 class="contentTitle">{$group->groupName|language}: {lang}wcf.user.moderatedUserGroups.applications{/lang} <span class="badge">{#$items}</span></h1>
		</div>
		
		<nav class="contentHeaderNavigation">
			<ul>
				<li><a href="{link controller='UserGroupManageMemberList' id=$group->groupID}{/link}" class="button"><span class="icon icon16 fa-list"></span> <span>{lang}wcf.user.moderatedUserGroups.members{/lang}</span></a></li>
				{event name='contentHeaderNavigation'}
			</ul>
		</nav>
	</header>
{/capture}

{include file='userMenuSidebar'}

{include file='header' __disableAds=true __sidebarLeftHasMenu=true}

{hascontent}
	<div class="paginationTop">
		{content}
			{pages print=true assign=pagesLinks controller='UserGroupManageApplicationList' id=$group->groupID link="pageNo=%d&sortField=$sortField&sortOrder=$sortOrder"}
		{/content}
	</div>
{/hascontent}

{if $items}
	<section class="section tabularBox">
		<h2 class="sectionTitle">{lang}wcf.user.moderatedUserGroups.applications{/lang}</h2>
		
		<table class="table">
			<thead>
				<tr>
					<th class="columnID columnApplicationID{if $sortField == 'applicationID'} active {@$sortOrder}{/if}" colspan="2"><a href="{link controller='UserGroupManageApplicationList' id=$group->groupID}pageNo={@$pageNo}&sortField=applicationID&sortOrder={if $sortField == 'applicationID' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{/link}">{lang}wcf.global.objectID{/lang}</a></th>
					<th class="columnTitle columnApplicant{if $sortField == 'username'} active {@$sortOrder}{/if}"><a href="{link controller='UserGroupManageApplicationList' id=$group->groupID}pageNo={@$pageNo}&sortField=username&sortOrder={if $sortField == 'username' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{/link}">{lang}wcf.user.username{/lang}</a></th>
					<th class="columnText columnStatus{if $sortField == 'status'} active {@$sortOrder}{/if}"><a href="{link controller='UserGroupManageApplicationList' id=$group->groupID}pageNo={@$pageNo}&sortField=status&sortOrder={if $sortField == 'status' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{/link}">{lang}wcf.user.userGroups.application.status{/lang}</a></th>
					<th class="columnDate columnTime{if $sortField == 'time'} active {@$sortOrder}{/if}"><a href="{link controller='UserGroupManageApplicationList' id=$group->groupID}pageNo={@$pageNo}&sortField=time&sortOrder={if $sortField == 'time' && $sortOrder == 'ASC'}DESC{else}ASC{/if}{/link}">{lang}wcf.user.userGroups.application.time{/lang}</a></th>
					
					{event name='columnHeads'}
				</tr>
			</thead>
			
			<tbody>
				{foreach from=$objects item=application}
					<tr class="jsApplicationRow">
						<td class="columnIcon">
							<a href="{link controller='UserGroupManageApplicationEdit' id=$application->applicationID}{/link}" title="{lang}wcf.global.button.edit{/lang}" class="jsTooltip"><span class="icon icon16 fa-pencil"></span></a>
							
							{event name='rowButtons'}
						</td>
						<td class="columnID">{#$application->applicationID}</td>
						<td class="columnTitle columnApplicant"><a href="{link controller='UserGroupManageApplicationEdit' id=$application->applicationID}{/link}" class="userLink" data-user-id="{$application->applicant}">{$application->username}</a></td>
						<td class="columnText columnStatus">{lang}wcf.user.userGroups.application.status.status{$application->status}{/lang}</td>
						<td class="columnDate columnTime">{@$application->time|time}</td>
						
						{event name='columns'}
					</tr>
				{/foreach}
			</tbody>
		</table>
	</section>
	
	<footer class="contentFooter">
		{hascontent}
			<div class="paginationBottom">
				{content}{@$pagesLinks}{/content}
			</div>
		{/hascontent}
		
		<nav class="contentFooterNavigation">
			<ul>
				<li><a href="{link controller='UserGroupManageMemberList' id=$group->groupID}{/link}" class="button"><span class="icon icon16 fa-list"></span> <span>{lang}wcf.user.moderatedUserGroups.members{/lang}</span></a></li>
				{event name='contentFooterNavigation'}
			</ul>
		</nav>
	</footer>
{else}
	<p class="info">{lang}wcf.user.moderatedUserGroups.noApplications{/lang}</p>
{/if}

{include file='footer'}
