{include file='userMenuSidebar'}

{include file='header' __disableAds=true __sidebarLeftHasMenu=true}

{hascontent}
	<div class="paginationTop">
		{content}
			{pages print=true assign=pagesLinks controller="UserGroupList" link="pageNo=%d"}
		{/content}
	</div>
{/hascontent}

{foreach from=$objects item='group'}
	<section class="section">
		<header class="sectionHeader">
			<h2 class="sectionTitle">{$group->groupName|language} <span class="badge label">{lang}wcf.acp.group.groupType.type{$group->groupType}{/lang}</span>{if $group->isMember()} <span class="badge label green">{lang}wcf.user.moderatedUserGroups.isMember{/lang}</span>{/if}</h2>
			<p class="sectionDescription">{@$group->groupDescription|language|newlineToBreak}</p>
		</header>
		
		{hascontent}
			<dl>
				<dt>{lang}wcf.acp.group.leader{/lang}</dt>
				<dd>
					<ul class="inlineList commaSeparated">
						{content}
							{foreach from=$group->leader item='leader'}
								<li><a href="{link controller='User' object=$leader}{/link}" class="userLink" data-user-id="{$leader->userID}"><span>{$leader}</span></a></li>
							{/foreach}
						{/content}
					</ul>
				</dd>
			</dl>
		{/hascontent}
		
		{event name='groupData'}
		
		{if $group->groupType == 5 || $group->groupType == 6 || $group->groupType == 7}{* open, moderated, closed moderated *}
			{if $group->isMember()}
				{if $group->groupType == 5 || $group->groupType == 6}{* open, moderated *}
					<dl>
						<dt></dt>
						<dd>
							<ul class="buttonList smallButtons">
								<li>
									<a class="button small" href="{link controller='UserGroupLeave' id=$group->groupID}t={@SECURITY_TOKEN}{/link}" onclick="WCF.System.Confirmation.show('{lang __encode=true}wcf.user.userGroups.leave.sure{/lang}', $.proxy(function (action) { if (action == 'confirm') window.location.href = $(this).attr('href'); }, this), undefined, undefined, true); return false;">
										<span>{lang}wcf.user.userGroups.leave{/lang}</span>
									</a>
								</li>
								{event name='groupButtons'}
							</ul>
						</dd>
					</dl>
				{/if}
			{else}
				{if $group->groupType == 5}{* open *}
					{if !$__wcf->user->activationCode}
						<dl>
							<dt></dt>
							<dd>
								<ul class="buttonList smallButtons">
									<li>
										<a class="button small" href="{link controller='UserGroupJoin' id=$group->groupID}t={@SECURITY_TOKEN}{/link}">
											<span>{lang}wcf.user.userGroups.join{/lang}</span>
										</a>
									</li>
									{event name='groupButtons'}
								</ul>
							</dd>
						</dl>
					{/if}
				{else}
					{if $group->application}
						<dl>
							<dt>{lang}wcf.user.userGroups.application.status{/lang}</dt>
							<dd>{lang}wcf.user.userGroups.application.status.status{$group->application->status}{/lang}</dd>
						</dl>
						
						{if $group->application->status != 2 && $group->application->status != 5}{* accepted, closed *}
							<dl>
								<dt></dt>
								<dd>
									<ul class="buttonList smallButtons">
										<li>
											<a class="button small" href="{link controller='UserGroupApplicationEdit' id=$group->application->applicationID}{/link}">
												<span>{lang}wcf.user.userGroups.application.edit{/lang}</span>
											</a>
										</li>
										<li>
											<a class="button small" href="{link controller='UserGroupApplicationRevoke' id=$group->application->applicationID}t={@SECURITY_TOKEN}{/link}" onclick="WCF.System.Confirmation.show('{lang __encode=true}wcf.user.userGroups.application.revoke.sure{/lang}', $.proxy(function (action) { if (action == 'confirm') window.location.href = $(this).attr('href'); }, this), undefined, undefined, true); return false;">
												<span>{lang}wcf.user.userGroups.application.revoke{/lang}</span>
											</a>
										</li>
										{event name='groupButtons'}
									</ul>
								</dd>
							</dl>
						{/if}
					{else}
						{if !$__wcf->user->activationCode}
							<dl>
								<dt></dt>
								<dd>
									<ul class="buttonList smallButtons">
										<li>
											<a class="button small" href="{link controller='UserGroupApply' id=$group->groupID}{/link}">
												<span>{lang}wcf.user.userGroups.apply{/lang}</span>
											</a>
										</li>
										{event name='groupButtons'}
									</ul>
								</dd>
							</dl>
						{/if}
					{/if}
				{/if}
			{/if}
		{/if}
	</section>
{/foreach}

<footer class="contentFooter">
	{hascontent}
		<div class="paginationBottom">
			{content}{@$pagesLinks}{/content}
		</div>
	{/hascontent}
	
	{hascontent}
		<nav class="contentFooterNavigation">
			<ul>
				{content}{event name='contentFooterNavigation'}{/content}
			</ul>
		</nav>
	{/hascontent}
</footer>

{include file='footer'}
