{capture assign='pageTitle'}{lang}wcf.user.userGroups.{if $application|isset}application.edit{else}apply{/if}{/lang}{if $isGroupLeader|isset} - {$group->groupName|language}{/if}{/capture}

{capture assign='contentTitle'}{lang}wcf.user.userGroups.{if $application|isset}application.edit{else}apply{/if}{/lang}{/capture}

{include file='userMenuSidebar'}

{include file='header' __disableAds=true __sidebarLeftHasMenu=true}

{include file='formError'}

<form method="post" action="{if $isGroupLeader|isset}{link controller='UserGroupManageApplicationEdit' id=$application->applicationID}{/link}{elseif $application|isset}{link controller='UserGroupApplicationEdit' id=$application->applicationID}{/link}{else}{link controller='UserGroupApply' id=$group->groupID}{/link}{/if}">
	<section class="section">
		<h2 class="sectionTitle">{lang}wcf.user.userGroups.apply.groupInformation{/lang}</h2>
		
		<dl>
			<dt>{lang}wcf.global.name{/lang}</dt>
			<dd>
				{$group->groupName|language}
			</dd>
		</dl>
		
		{if $group->groupDescription|language && !$isGroupLeader|isset}
			<dl>
				<dt>{lang}wcf.acp.group.description{/lang}</dt>
				<dd>
					{$group->groupDescription|language}
				</dd>
			</dl>
		{/if}
		
		{event name='groupInformationFields'}
	</section>
	
	<section class="section">
		<h2 class="sectionTitle">{lang}wcf.user.userGroups.apply.applicationInformation{/lang}</h2>
		
		{if $isGroupLeader|isset}
			<dl>
				<dt>{lang}wcf.user.username{/lang}</dt>
				<dd>
					<a href="{link controller='User' id=$application->applicant title=$application->username}{/link}" class="userLink" data-user-id="{$application->applicant}">
						{$application->username}
					</a>
				</dd>
			</dl>
		{/if}
		
		{if $application|isset}
			<dl{if $errorField == 'status'} class="formError"{/if}>
				<dt><label for="status">{lang}wcf.user.userGroups.application.status{/lang}</label></dt>
				<dd>
					{if !$isGroupLeader|isset || $application->status == 2}{* accepted *}
						{lang}wcf.user.userGroups.application.status.status{$status}{/lang}
					{else}
						<select id="status" name="status">
							<option value="1"{if $status == 1} selected{/if}>{lang}wcf.user.userGroups.application.status.status1{/lang}</option>
							<option value="2"{if $status == 2} selected{/if}>{lang}wcf.user.userGroups.application.status.status2{/lang}</option>
							<option value="3"{if $status == 3} selected{/if}>{lang}wcf.user.userGroups.application.status.status3{/lang}</option>
							<option value="5"{if $status == 5} selected{/if}>{lang}wcf.user.userGroups.application.status.status5{/lang}</option>
						</select>
					{/if}
				</dd>
			</dl>
			
			{if ($isGroupLeader|isset && $application->status != 2) || $reply}
				<dl{if $errorField == 'reply'} class="formError"{/if}>
					<dt><label for="reply">{lang}wcf.user.userGroups.application.reply{/lang}</label></dt>
					<dd>
						{if !$isGroupLeader|isset || $application->status == 2}{* accepted *}
							{@$reply|newlineToBreak}
						{else}
							<textarea id="reply" name="reply" cols="40" rows="10">{$reply}</textarea>
						{/if}
					</dd>
				</dl>
			{/if}
		{/if}
		
		<dl{if $errorField == 'reason'} class="formError"{/if}>
			<dt><label for="reason">{lang}wcf.user.userGroups.apply.reason{/lang}</label></dt>
			<dd>
				{if !$isGroupLeader|isset}
					<textarea id="reason" name="reason" cols="40" rows="10" required>{$reason}</textarea>
				{else}
					{@$reason|newlineToBreak}
				{/if}
				
				{if $errorField == 'reason'}
					<small class="innerError">
						{if $errorType == 'empty'}{lang}wcf.global.form.error.empty{/lang}{/if}
					</small>
				{/if}
			</dd>
		</dl>
		
		{event name='applicationInformationFields'}
	</section>
	
	{event name='sections'}
	
	{if !$application|isset || $application->status != 2}{* accepted *}
		<div class="formSubmit">
			<input type="submit" value="{lang}wcf.global.button.submit{/lang}" accesskey="s">
			{@SECURITY_TOKEN_INPUT_TAG}
		</div>
	{/if}
</form>

{if $modificationLog|isset}
	{hascontent}
		<section class="section tabularBox">
			<h2 class="sectionTitle">{lang}wcf.user.userGroups.application.log{/lang} <span class="badge badgeInverse">{#$modificationLog|count}</span></h2>
			
			<table class="table">
				<thead>
					<tr>
						<th class="columnText">{lang}wcf.user.userGroups.application.log.action{/lang}</th>
						<th class="columnText">{lang}wcf.user.username{/lang}</th>
						<th class="columnDate">{lang}wcf.user.userGroups.application.log.time{/lang}</th>
						
						{event name='columnHeads'}
					</tr>
				</thead>
				<tbody>
					{content}
						{foreach from=$modificationLog item=entry}
							<tr>
								<td class="columnText">{@$entry}</td>
								<td class="columnText"><a href="{link controller='User' id=$entry->userID title=$entry->username}{/link}" class="userLink" data-user-id="{@$entry->userID}">{$entry->username}</a></td>
								<td class="columnDate">{@$entry->time|time}</td>
								
								{event name='columns'}
							</tr>
						{/foreach}
					{/content}
				</tbody>
			</table>
		</section>
	{/hascontent}
{/if}

{if $application|isset && $application->getGroup()->isLeader()}
	{include file='__commentJavaScript' commentContainerID='userGroupApplicationCommentList'}
	
	<section id="comments" class="section sectionContainerList userGroupApplicationComments">
		<header class="sectionHeader">
			<h2 class="sectionTitle">{lang}wcf.global.comments{/lang} <span class="badge">{#$application->comments}</span></h2>
			<p class="sectionDescription">{lang}wcf.user.userGroups.application.comments.description{/lang}</p>
		</header>
	
		<ul id="userGroupApplicationCommentList" class="commentList containerList" data-can-add="true" data-object-id="{@$application->applicationID}" data-object-type-id="{@$commentObjectTypeID}" data-comments="{if $application->comments}{@$commentList->countObjects()}{else}0{/if}" data-last-comment-time="{@$lastCommentTime}">
			{include file='commentListAddComment' wysiwygSelector='userGroupApplicationCommentListAddComment'}
			{include file='commentList'}
		</ul>
	</section>
{/if}

{include file='footer'}
