{include file='userMenuSidebar'}

{include file='header' __disableAds=true __sidebarLeftHasMenu=true}

{hascontent}
	<div class="paginationTop">
		{content}
			{pages print=true assign=pagesLinks controller="ModeratedUserGroupList" link="pageNo=%d"}
		{/content}
	</div>
{/hascontent}

{foreach from=$objects item='group'}
	<section class="section">
		<header class="sectionHeader">
			<h2 class="sectionTitle">{$group->groupName|language} <span class="badge label">{lang}wcf.acp.group.groupType.type{$group->groupType}{/lang}</span></h2>
			<p class="sectionDescription">{@$group->groupDescription|language|newlineToBreak}</p>
		</header>
		
		{if $group->groupType == 6 || $group->groupType == 7}{* moderated, closed moderated *}
			<dl>
				<dt>{lang}wcf.user.moderatedUserGroups.applications{/lang}</dt>
				<dd>{#$group->applications}{if $group->newApplications} <span class="badge badgeUpdate">{#$group->newApplications}</span>{/if}</dd>
			</dl>
		{/if}
		<dl>
			<dt>{lang}wcf.user.moderatedUserGroups.members{/lang}</dt>
			<dd>{#$group->members}</dd>
		</dl>
		{hascontent}
			<dl>
				<dt>{lang}wcf.acp.group.leader{/lang}</dt>
				<dd>
					<ul class="inlineList commaSeparated">
						{content}
							{foreach from=$group->leader item='leader'}
								<li><a href="{link controller='User' object=$leader}{/link}" class="userLink" data-user-id="{$leader->userID}"><span>{$leader}</span></a></li>
							{/foreach}
						{/content}
					</ul>
				</dd>
			</dl>
		{/hascontent}
		
		{event name='groupData'}
		
		<dl>
			<dt></dt>
			<dd>
				<ul class="buttonList smallButtons">
					<li><a class="button small" href="{link controller='UserGroupManageMemberList' id=$group->groupID}{/link}">{lang}wcf.user.moderatedUserGroups.members{/lang}</a></li>
					{if $group->groupType == 6 || $group->groupType == 7}<li><a class="button small" href="{link controller='UserGroupManageApplicationList' id=$group->groupID}{/link}">{lang}wcf.user.moderatedUserGroups.applications{/lang}</a></li>{/if}
					{event name='groupButtons'}
				</ul>
			</dd>
		</dl>
	</section>
{/foreach}

<footer class="contentFooter">
	{hascontent}
		<div class="paginationBottom">
			{content}{@$pagesLinks}{/content}
		</div>
	{/hascontent}
	
	{hascontent}
		<nav class="contentFooterNavigation">
			<ul>
				{content}{event name='contentFooterNavigation'}{/content}
			</ul>
		</nav>
	{/hascontent}
</footer>

{include file='footer'}
