<?php
namespace wcf\system\user\notification\object\type;
use wcf\data\comment\Comment;
use wcf\system\comment\CommentHandler;
use wcf\system\database\util\PreparedStatementConditionBuilder;
use wcf\system\WCF;

/**
 * Implements IMultiRecipientCommentUserNotificationObjectType::getRecipientIDs()
 * for user group application comment user notification object types.
 *
 * @author	Mathias Schmidt
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Core\System\User\Notification\Object\Type
 * @since	3.0
 */
trait TMultiRecipientUserGroupApplicationCommentUserNotificationObjectType {
	/**
	 * @inheritDoc
	 */
	public function getRecipientIDs(Comment $comment) {
		$objectTypeID = CommentHandler::getInstance()->getObjectTypeID('com.woltlab.wcf.moderatedUserGroup.application');
		if ($comment->objectTypeID != $objectTypeID) {
			return [];
		}
		
		// 1. fetch users who commented on the user group application
		// 2. fetch users who responded to a comment on the user group application
		$sql = "(
				SELECT		DISTINCT userID
				FROM		wcf".WCF_N."_comment
				WHERE		objectID = ?
						AND objectTypeID = ?
			)
			UNION
			(
				SELECT		DISTINCT comment_response.userID
				FROM		wcf".WCF_N."_comment_response comment_response
				INNER JOIN	wcf".WCF_N."_comment comment
				ON		(comment.commentID = comment_response.commentID)
				WHERE		comment.objectID = ?
						AND comment.objectTypeID = ?
			)";
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute([
			$comment->objectID,
			$objectTypeID,
			$comment->objectID,
			$objectTypeID
		]);
		$recipientIDs = $statement->fetchAll(\PDO::FETCH_COLUMN);
		
		// make sure that all users can (still) access the user group application
		if (!empty($recipientIDs)) {
			$conditionBuilder = new PreparedStatementConditionBuilder();
			$conditionBuilder->add('user_group_leader.leaderID IN (?)', [$recipientIDs]);
			$conditionBuilder->add('user_group_application.applicationID = ?', [$comment->objectID]);
			$sql = "SELECT		leaderID
				FROM		wcf".WCF_N."_user_group_leader user_group_leader
				LEFT JOIN	wcf".WCF_N."_user_group_application user_group_application
				ON		(user_group_application.groupID = user_group_leader.groupID)
				".$conditionBuilder;
			$statement = WCF::getDB()->prepareStatement($sql);
			$statement->execute($conditionBuilder->getParameters());
			$recipientIDs = $statement->fetchAll(\PDO::FETCH_COLUMN);
		}
		
		return $recipientIDs;
	}
}
