<?php
namespace wcf\system\user\notification\object;
use wcf\data\user\group\application\UserGroupApplication;
use wcf\data\DatabaseObjectDecorator;

/**
 * Represents an user group application notification object.
 * 
 * @author	Tim Duesterhus
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Core\System\User\Notification\Object
 * 
 * @method	UserGroupApplication	getDecoratedObject()
 * @mixin	UserGroupApplication
 */
class UserGroupApplicationUserNotificationObject extends DatabaseObjectDecorator implements IUserNotificationObject {
	/**
	 * @inheritDoc
	 */
	protected static $baseClass = UserGroupApplication::class;
	
	/**
	 * @inheritDoc
	 */
	public function getTitle() {
		return '';
	}
	
	/**
	 * @inheritDoc
	 */
	public function getURL() {
		return '';
	}
	
	/**
	 * @inheritDoc
	 */
	public function getAuthorID() {
		return $this->applicant;
	}
}
