<?php
namespace wcf\system\user\notification\event;
use wcf\data\user\group\application\UserGroupApplication;
use wcf\data\user\group\application\UserGroupApplicationAction;
use wcf\data\user\group\UserGroup;
use wcf\data\user\group\UserGroupAction;
use wcf\data\user\UserProfile;
use wcf\system\WCF;

/**
 * Provides methods to create moderated user groups and user group applications
 * for testing user notification events.
 *
 * @author	Matthias Schmidt
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Core\System\User\Notification\Event
 * @since	3.1
 */
trait TTestableUserGroupApplicationRelatedUserNotificationEvent {
	/**
	 * Creates a moderated user group for testing.
	 * 
	 * @param	UserProfile	$groupLeader
	 * @return	UserGroup
	 */
	public static function createTestModeratedUserGroup(UserProfile $groupLeader) {
		/** @var UserGroup $userGroup */
		$userGroup = (new UserGroupAction([], 'create', [
			'data' => [
				'groupName' => 'Test Moderated Group Name',
				'groupDescription' => 'Test Moderated Group Description',
				'groupType' => 6
			]
		]))->executeAction()['returnValues'];
		
		$sql = "INSERT INTO	wcf".WCF_N."_user_group_leader
					(groupID, leaderID)
			VALUES		(?, ?)";
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute([$userGroup->groupID, $groupLeader->userID]);
		
		return $userGroup;
	}
	
	/**
	 * Creates a user group application for testing.
	 * 
	 * @param	UserProfile	$groupLeader
	 * @param	UserProfile	$applicant
	 * @return	UserGroupApplication
	 */
	public static function createTestUserGroupApplication(UserProfile $groupLeader, UserProfile $applicant) {
		return (new UserGroupApplicationAction([], 'create', [
			'data' => [
				'applicant' => $applicant->userID,
				'username' => $applicant->username,
				'groupID' => self::createTestModeratedUserGroup($groupLeader)->groupID,
				'time' => TIME_NOW,
				'reason' => 'Test User Group Application Reason'
			]
		]))->executeAction()['returnValues'];
	}
}
