<?php
namespace wcf\system\user\notification\event;
use wcf\data\user\UserProfile;
use wcf\system\comment\CommentHandler;

/**
 * Provides a default implementation of
 * 	`TTestableCommentLikeUserNotificationEvent::getTestCommentObjectData()`
 * used for user group application comment-related and entry comment response-related
 * user notification events.
 * 
 * @author	Matthias Schmidt
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Core\System\User\Notification\Event
 * @since	3.1
 */
trait TTestableUserGroupApplicationCommentUserNotificationEvent {
	use TTestableUserGroupApplicationRelatedUserNotificationEvent;
	
	/**
	 * @see	TTestableUserNotificationEvent::canBeTriggeredByGuests()
	 */
	public static function canBeTriggeredByGuests() {
		return false;
	}
	
	/**
	 * @see	TTestableCommentUserNotificationEvent::getTestCommentObjectData()
	 */
	protected static function getTestCommentObjectData(UserProfile $recipient, UserProfile $author) {
		return [
			'objectID' => self::createTestUserGroupApplication($author, $recipient)->applicationID,
			'objectTypeID' => CommentHandler::getInstance()->getObjectTypeID('com.woltlab.wcf.moderatedUserGroup.application')
		];
	}
}
