<?php
namespace wcf\system\menu\user;
use wcf\data\user\group\UserGroup;

/**
 * UserMenuItemProvider for user groups.
 * 
 * @author	Tim Duesterhus
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Core\System\Menu\User
 */
class UserGroupsMenuItemProvider extends DefaultUserMenuItemProvider {
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function isVisible() {
		// only show menu item if there are valid user group
		$userGroups = UserGroup::getGroupsByType([5, 6, 7]); // open, moderated, closed moderated
		
		foreach ($userGroups as $userGroup) {
			// admin groups are not allowed
			if (!$userGroup->isAdminGroup()) return true;
		}
		
		return false;
	}
}
