<?php
namespace wcf\system\menu\user;
use wcf\data\user\group\ModeratedUserGroup;

/**
 * UserMenuItemProvider for user groups.
 * 
 * @author	Tim Duesterhus
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Core\System\Menu\User
 */
class ModeratedUserGroupsMenuItemProvider extends DefaultUserMenuItemProvider {
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function isVisible() {
		// only show menu item if the user is the leader of a user group
		return ModeratedUserGroup::isGroupLeader();
	}
}
