<?php
namespace wcf\system\log\modification;
use wcf\data\user\group\application\UserGroupApplication;
use wcf\system\exception\SystemException;

/**
 * Handles user group application modification logs.
 * 
 * @author	Tim Duesterhus
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Core\System\Log\Modification
 */
class UserGroupApplicationModificationLogHandler extends AbstractModificationLogHandler {
	/**
	 * @inheritDoc
	 */
	protected $objectTypeName = 'com.woltlab.wcf.moderatedUserGroup.application';
	
	/**
	 * Adds a log entry for a change of the status.
	 * 
	 * @param	UserGroupApplication	$application
	 * @param	integer 		$newStatus
	 * @throws	SystemException
	 */
	public function changeStatus(UserGroupApplication $application, $newStatus) {
		switch ($newStatus) {
			case UserGroupApplication::STATUS_NEW:
			case UserGroupApplication::STATUS_IN_PROCESS:
			case UserGroupApplication::STATUS_ACCEPTED:
			case UserGroupApplication::STATUS_REJECTED:
			case UserGroupApplication::STATUS_CLOSED:
				// they are fine
			break;
			default:
				throw new SystemException('Unexpected value for $newStatus, expected one of UserGroupApplication::STATUS_*, but got: '.$newStatus);
		}
		
		$this->add($application, 'changeStatus', ['newStatus' => $newStatus]);
	}
	
	/**
	 * Adds a log entry for an edit of the reason.
	 * 
	 * @param	UserGroupApplication	$application
	 */
	public function editReason(UserGroupApplication $application) {
		$this->add($application, 'editReason');
	}
	
	/**
	 * Adds a log entry for an edit of the reply.
	 * 
	 * @param	UserGroupApplication	$application
	 */
	public function editReply(UserGroupApplication $application) {
		$this->add($application, 'editReply');
	}
	
	/**
	 * Adds a user group application modification log entry.
	 * 
	 * @param	UserGroupApplication	$application
	 * @param	string			$action
	 * @param	array			$additionalData
	 */
	public function add(UserGroupApplication $application, $action, array $additionalData = []) {
		$this->createLog($action, $application->applicationID, null, $additionalData);
	}
}
