<?php
namespace wcf\system\comment\manager;
use wcf\data\user\group\application\UserGroupApplication;
use wcf\data\user\group\application\UserGroupApplicationEditor;
use wcf\system\request\LinkHandler;

/**
 * Comment manager implementation for user group application comments.
 * 
 * @author	Matthias Schmidt
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Core\System\Comment\Manager
 * @since	3.0
 */
class UserGroupApplicationCommentManager extends AbstractCommentManager {
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function canAdd($objectID) {
		return $this->isAccessible($objectID, true);
	}
	
	/**
	 * @inheritDoc
	 * @since	3.1
	 */
	public function canAddWithoutApproval($objectID) {
		// we do not have specific permissions to comment on user group applications
		return $this->canAdd($objectID);
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	protected function canEdit($isOwner) {
		return $isOwner;
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	protected function canDelete($isOwner) {
		return $isOwner;
	}
	
	/**
	 * @inheritDoc
	 */
	public function getLink($objectTypeID, $objectID) {
		return LinkHandler::getInstance()->getLink('UserGroupManageApplicationEdit', [
			'id' => $objectID
		]);
	}
	
	/**
	 * @inheritDoc
	 */
	public function getTitle($objectTypeID, $objectID, $isResponse = false) {
		return '';
	}
	
	/**
	 * @inheritDoc
	 */
	public function isAccessible($objectID, $validateWritePermission = false) {
		return (new UserGroupApplication($objectID))->getGroup()->isLeader();
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function supportsLike() {
		return false;
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function supportsReport() {
		return false;
	}
	
	/**
	 * @inheritDoc
	 */
	public function updateCounter($objectID, $value) {
		$editor = new UserGroupApplicationEditor(new UserGroupApplication($objectID));
		$editor->updateCounters(['comments' => $value]);
		$editor->update(['lastChangeTime' => TIME_NOW]);
	}
}
