<?php
namespace wcf\page;
use wcf\acp\page\UserGroupListPage;
use wcf\data\user\group\application\UserGroupApplication;
use wcf\data\user\group\application\UserGroupApplicationList;
use wcf\data\user\UserList;
use wcf\system\exception\PermissionDeniedException;
use wcf\system\menu\user\UserMenu;
use wcf\system\WCF;

/**
 * Lists groups the current user leads.
 * 
 * @author	Tim Duesterhus
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Core\Page
 */
class ModeratedUserGroupListPage extends UserGroupListPage {
	/**
	 * @inheritDoc
	 */
	public $activeMenuItem = '';
	
	/**
	 * @inheritDoc
	 */
	public $loginRequired = true;
	
	/**
	 * @inheritDoc
	 */
	public $neededPermissions = [];
	
	/**
	 * list of applications for the current user
	 * @var	UserGroupApplicationList
	 */
	public $applicationList;
	
	/**
	 * list of group leaders
	 * @var	UserList
	 */
	public $leaderList;
	
	/**
	 * @inheritDoc
	 */
	public $itemsPerPage = 7;
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	protected function initObjectList() {
		SortablePage::initObjectList();
		
		$this->objectList->sqlSelects .= "(SELECT COUNT(*) FROM wcf".WCF_N."_user_group_application WHERE groupID = user_group.groupID) AS applications,
		(SELECT COUNT(*) FROM wcf".WCF_N."_user_group_application WHERE groupID = user_group.groupID AND status = ".UserGroupApplication::STATUS_NEW.") AS newApplications,
		(SELECT COUNT(*) FROM wcf".WCF_N."_user_to_group WHERE groupID = user_group.groupID) AS members";
		$this->objectList->sqlJoins = $this->objectList->sqlConditionJoins .= " INNER JOIN wcf".WCF_N."_user_group_leader group_leader ON user_group.groupID = group_leader.groupID";
		$this->objectList->getConditionBuilder()->add('group_leader.leaderID = ?', [WCF::getUser()->userID]);
		
		// read group leaders
		$this->leaderList = new UserList();
		$this->leaderList->sqlJoins .= " INNER JOIN wcf".WCF_N."_user_group_leader group_leader ON user_table.userID = group_leader.leaderID";
	}
	
	/**
	 * @inheritDoc
	 */
	public function readData() {
		parent::readData();
		
		if (!count($this->objectList)) throw new PermissionDeniedException();
		
		// assign leaders to groups
		$this->leaderList->readObjects();
		$sql = "SELECT	*
			FROM	wcf".WCF_N."_user_group_leader";
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute();
		while (($row = $statement->fetchArray())) {
			if (($group = $this->objectList->search($row['groupID'])) === null) continue;
			
			/** @noinspection PhpUndefinedFieldInspection */
			if (!is_array($group->leader)) {
				/** @noinspection PhpUndefinedFieldInspection */
				$group->leader = [];
			}
			/** @noinspection PhpUndefinedFieldInspection */
			$group->leader[] = $this->leaderList->search($row['leaderID']);
		}
	}
	
	/**
	 * @inheritDoc
	 */
	public function show() {
		// set active tab
		UserMenu::getInstance()->setActiveMenuItem('wcf.user.menu.moderatedUserGroups');
		
		parent::show();
	}
}
