<?php
namespace wcf\data\user\group\application;
use wcf\data\DatabaseObjectEditor;
use wcf\system\log\modification\UserGroupApplicationModificationLogHandler;

/**
 * An editor for user group applications
 * 
 * @author	Tim Duesterhus
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Core\Data\User\Group\Application
 * 
 * @method static	UserGroupApplication	create(array $parameters = [])
 * @method		UserGroupApplication	getDecoratedObject()
 * @mixin		UserGroupApplication
 */
class UserGroupApplicationEditor extends DatabaseObjectEditor {
	/**
	 * @inheritDoc
	 */
	protected static $baseClass = UserGroupApplication::class;
	
	/**
	 * @inheritDoc
	 */
	public static function deleteAll(array $objectIDs = []) {
		UserGroupApplicationModificationLogHandler::getInstance()->deleteLogs($objectIDs);
		
		return parent::deleteAll($objectIDs);
	}
}
