<?php
namespace wcf\data\user\group\application;
use wcf\data\AbstractDatabaseObjectAction;
use wcf\system\log\modification\UserGroupApplicationModificationLogHandler;
use wcf\system\WCF;

/**
 * Executes actions on an user group application.
 * 
 * @author	Tim Duesterhus
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Core\Data\User\Group\Application
 * 
 * @method	UserGroupApplicationEditor[]	getObjects()
 * @method	UserGroupApplicationEditor	getSingleObject()
 */
class UserGroupApplicationAction extends AbstractDatabaseObjectAction {
	/**
	 * @inheritDoc
	 */
	protected $className = UserGroupApplicationEditor::class;
	
	/**
	 * @inheritDoc
	 * @return	UserGroupApplication
	 */
	public function create() {
		if (!isset($this->parameters['data']['time'])) {
			$this->parameters['data']['time'] = TIME_NOW;
		}
		if (!isset($this->parameters['data']['lastChangeTime'])) {
			$this->parameters['data']['lastChangeTime'] = TIME_NOW;
		}
		
		return parent::create();
	}
	
	/**
	 * @inheritDoc
	 */
	public function update() {
		WCF::getDB()->beginTransaction();
		parent::update();
		
		$logHandler = UserGroupApplicationModificationLogHandler::getInstance();
		foreach ($this->getObjects() as $application) {
			if (isset($this->parameters['data']['status']) && $this->parameters['data']['status'] != $application->status) {
				$logHandler->changeStatus($application->getDecoratedObject(), $this->parameters['data']['status']);
			}
			if (isset($this->parameters['data']['reason']) && $this->parameters['data']['reason'] != $application->reason) {
				$logHandler->editReason($application->getDecoratedObject());
			}
			if (isset($this->parameters['data']['reply']) && $this->parameters['data']['reply'] != $application->reply) {
				$logHandler->editReply($application->getDecoratedObject());
			}
		}
		WCF::getDB()->commitTransaction();
	}
}
