<?php
namespace wcf\data\user\group;
use wcf\data\DatabaseObjectDecorator;
use wcf\data\ITitledLinkObject;
use wcf\system\request\LinkHandler;
use wcf\system\WCF;

/**
 * Decorator for moderated user groups.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2018 WoltLab GmbH
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 * @package	WoltLabSuite\Core\Data\User\Group
 *
 * @method	UserGroup	getDecoratedObject()
 * @mixin	UserGroup
 */
class ModeratedUserGroup extends DatabaseObjectDecorator implements ITitledLinkObject {
	/**
	 * @inheritDoc
	 */
	protected static $baseClass = UserGroup::class;
	
	/**
	 * true if the active user is a group leader
	 * @var	boolean
	 */
	protected static $groupLeaderStatus;
	
	/**
	 * @inheritDoc
	 */
	public function getLink() {
		return LinkHandler::getInstance()->getLink('UserGroupManageApplicationList', [
			'forceFrontend' => true,
			'object' => $this
		]);
	}
	
	/**
	 * @inheritDoc
	 */
	public function getTitle() {
		return $this->getDecoratedObject()->getTitle();
	}
	
	/**
	 * Returns true if the active use is a leader of this group.
	 * 
	 * @return	boolean
	 */
	public function isLeader() {
		$sql = "SELECT	COUNT(*) AS count
			FROM	wcf".WCF_N."_user_group_leader
			WHERE	groupID = ?
				AND leaderID = ?";
		$statement = WCF::getDB()->prepareStatement($sql);
		$statement->execute([$this->groupID, WCF::getUser()->userID]);
		$row = $statement->fetchArray();
		if ($row['count']) return true;
		
		return false;
	}
	
	/**
	 * Returns true if the active user is a group leader.
	 * 
	 * @return	boolean
	 */
	public static function isGroupLeader() {
		if (self::$groupLeaderStatus === null) {
			$sql = "SELECT	COUNT(*) AS count
				FROM	wcf".WCF_N."_user_group_leader
				WHERE	leaderID = ?";
			$statement = WCF::getDB()->prepareStatement($sql);
			$statement->execute([WCF::getUser()->userID]);
			$row = $statement->fetchArray();
			
			self::$groupLeaderStatus = ($row['count'] ? true : false);
		}
		
		return self::$groupLeaderStatus;
	}
}
