<?php
namespace wcf\data\modification\log;
use wcf\system\log\modification\UserGroupApplicationModificationLogHandler;

/**
 * Represents a list of modification logs for user group applications.
 * 
 * @author	Tim Duesterhus
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Core\Data\Modification\Log
 * 
 * @method	ViewableUserGroupApplicationModificationLog		current()
 * @method	ViewableUserGroupApplicationModificationLog[]		getObjects()
 * @method	ViewableUserGroupApplicationModificationLog|null	search($objectID)
 * @property	ViewableUserGroupApplicationModificationLog[]		$objects
 */
class ViewableUserGroupApplicationModificationLogList extends ModificationLogList {
	/**
	 * @inheritDoc
	 */
	public $decoratorClassName = ViewableUserGroupApplicationModificationLog::class;
	
	/**
	 * Initializes the user group application modification log list.
	 * 
	 * @param	integer[]		$applicationIDs
	 * @param	string			$action
	 */
	public function setApplicationData(array $applicationIDs, $action = '') {
		$this->getConditionBuilder()->add("objectTypeID = ?", [UserGroupApplicationModificationLogHandler::getInstance()->getObjectType()->objectTypeID]);
		$this->getConditionBuilder()->add("objectID IN (?)", [$applicationIDs]);
		if (!empty($action)) $this->getConditionBuilder()->add("action = ?", [$action]);
	}
}
