<?php
namespace wcf\data\modification\log;
use wcf\data\user\group\application\UserGroupApplication;
use wcf\data\DatabaseObjectDecorator;
use wcf\system\WCF;

/**
 * Provides a viewable user group application modification log.
 * 
 * @author	Tim Duesterhus
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Core\Data\Modification\Log
 * 
 * @method	ModificationLog		getDecoratedObject()
 * @mixin	ModificationLog
 */
class ViewableUserGroupApplicationModificationLog extends DatabaseObjectDecorator {
	/**
	 * @inheritDoc
	 */
	protected static $baseClass = ModificationLog::class;
	
	/**
	 * application object
	 * @var	UserGroupApplication
	 */
	public $application;
	
	/**
	 * Returns readable representation of current log entry.
	 * 
	 * @return	string
	 */
	public function __toString() {
		return WCF::getLanguage()->getDynamicVariable('wcf.user.userGroups.application.log.'.$this->action, [
			'additionalData' => $this->additionalData,
			'application' => $this->application
		]);
	}
	
	/**
	 * Sets user group application object and returns true if the object has been successfully set.
	 * 
	 * @param	UserGroupApplication	$application
	 * @return	boolean
	 */
	public function setApplication(UserGroupApplication $application) {
		if ($application->applicationID == $this->objectID) {
			$this->application = $application;
			
			return true;
		}
		
		return false;
	}
}
