<?php
namespace wcf\action;
use wcf\data\user\group\application\UserGroupApplication;
use wcf\data\user\group\application\UserGroupApplicationEditor;
use wcf\data\user\group\UserGroup;
use wcf\data\user\UserProfileAction;
use wcf\system\exception\IllegalLinkException;
use wcf\system\exception\PermissionDeniedException;
use wcf\system\request\LinkHandler;
use wcf\system\WCF;
use wcf\util\HeaderUtil;

/**
 * Allows the user to leave open and moderated groups.
 * 
 * @author	Tim Duesterhus
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Core\Action
 */
class UserGroupLeaveAction extends AbstractSecureAction {
	/**
	 * @inheritDoc
	 */
	public $loginRequired = true;
	
	/**
	 * database object action
	 * @var	\wcf\data\AbstractDatabaseObjectAction
	 */
	public $objectAction;
	
	/**
	 * given groupID
	 * @var	integer
	 */
	public $groupID = 0;
	
	/**
	 * instance of the group with the given id
	 * @var	UserGroup
	 */
	public $group;
	
	/**
	 * @inheritDoc
	 */
	public function readParameters() {
		parent::readParameters();
		
		if (isset($_GET['id'])) $this->groupID = intval($_GET['id']);
		$this->group = new UserGroup($this->groupID);
		if (!$this->group->groupID) throw new IllegalLinkException();
	}
	
	/**
	 * @inheritDoc
	 */
	public function execute() {
		parent::execute();
		
		// open, moderated
		if ($this->group->groupType != 5 && $this->group->groupType != 6) {
			throw new PermissionDeniedException();
		}
		
		if (!$this->group->isMember()) {
			throw new PermissionDeniedException();
		}
		
		$data = [
			'removeGroups' => [$this->group->groupID]
		];
		$this->objectAction = new UserProfileAction([WCF::getUser()->userID], 'update', $data);
		$this->objectAction->executeAction();
		
		$updateUserRankAction = new UserProfileAction([WCF::getUser()->userID], 'updateUserRank');
		$updateUserRankAction->executeAction();
		
		$updateUserOnlineMarkingAction = new UserProfileAction([WCF::getUser()->userID], 'updateUserOnlineMarking');
		$updateUserOnlineMarkingAction->executeAction();
		
		$applicationEditor = new UserGroupApplicationEditor(UserGroupApplication::getApplicationByApplicantAndGroup(WCF::getUser()->userID, $this->group->groupID));
		$applicationEditor->delete();
		
		$this->executed();
		
		// forward to user group list page
		HeaderUtil::redirect(LinkHandler::getInstance()->getLink('UserGroupList'));
		exit;
	}
}
