<?php
namespace wcf\action;
use wcf\data\user\group\UserGroup;
use wcf\data\user\UserProfileAction;
use wcf\system\exception\IllegalLinkException;
use wcf\system\exception\PermissionDeniedException;
use wcf\system\request\LinkHandler;
use wcf\system\WCF;
use wcf\util\HeaderUtil;

/**
 * Allows the user to join open groups.
 * 
 * @author	Tim Duesterhus
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Core\Action
 */
class UserGroupJoinAction extends AbstractSecureAction {
	/**
	 * @inheritDoc
	 */
	public $loginRequired = true;
	
	/**
	 * database object action
	 * @var	\wcf\data\AbstractDatabaseObjectAction
	 */
	public $objectAction;
	
	/**
	 * given groupID
	 * @var	integer
	 */
	public $groupID = 0;
	
	/**
	 * instance of the group with the given id
	 * @var	UserGroup
	 */
	public $group;
	
	/**
	 * @inheritDoc
	 */
	public function readParameters() {
		parent::readParameters();
		
		if (isset($_GET['id'])) $this->groupID = intval($_GET['id']);
		$this->group = new UserGroup($this->groupID);
		if (!$this->group->groupID) throw new IllegalLinkException();
		
		// check account status
		if (WCF::getUser()->activationCode) {
			throw new PermissionDeniedException();
		}
	}
	
	/**
	 * @inheritDoc
	 */
	public function execute() {
		parent::execute();
		
		// open
		if ($this->group->groupType != 5) {
			throw new PermissionDeniedException();
		}
		
		if ($this->group->isMember()) {
			throw new PermissionDeniedException();
		}
		
		if ($this->group->isAdminGroup()) {
			throw new PermissionDeniedException();
		}
		
		$groups = WCF::getUser()->getGroupIDs();
		$groups[] = $this->group->groupID;
		
		$data = [
			'groups' => $groups
		];
		$this->objectAction = new UserProfileAction([WCF::getUser()->userID], 'update', $data);
		$this->objectAction->executeAction();
		
		$updateUserRankAction = new UserProfileAction([WCF::getUser()->userID], 'updateUserRank');
		$updateUserRankAction->executeAction();
		
		$updateUserOnlineMarkingAction = new UserProfileAction([WCF::getUser()->userID], 'updateUserOnlineMarking');
		$updateUserOnlineMarkingAction->executeAction();
		
		$this->executed();
		
		// forward to user group list page
		HeaderUtil::redirect(LinkHandler::getInstance()->getLink('UserGroupList'));
		exit;
	}
}
