<?php
namespace wcf\action;
use wcf\data\user\group\application\UserGroupApplication;
use wcf\data\user\group\application\UserGroupApplicationEditor;
use wcf\system\exception\IllegalLinkException;
use wcf\system\exception\PermissionDeniedException;
use wcf\system\request\LinkHandler;
use wcf\util\HeaderUtil;

/**
 * Allows the user to revoke his application.
 * 
 * @author	Tim Duesterhus
 * @copyright	2001-2018 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Core\Action
 */
class UserGroupApplicationRevokeAction extends AbstractSecureAction {
	/**
	 * @inheritDoc
	 */
	public $loginRequired = true;
	
	/**
	 * database object action
	 * @var	\wcf\data\AbstractDatabaseObjectAction
	 */
	public $objectAction;
	
	/**
	 * given applicationID
	 * @var	integer
	 */
	public $applicationID = 0;
	
	/**
	 * instance of the application with the given id
	 * @var	UserGroupApplication
	 */
	public $application;
	
	/**
	 * @inheritDoc
	 */
	public function readParameters() {
		parent::readParameters();
		
		if (isset($_GET['id'])) $this->applicationID = intval($_GET['id']);
		$this->application = new UserGroupApplication($this->applicationID);
		if (!$this->application->applicationID) throw new IllegalLinkException();
	}
	
	/**
	 * @inheritDoc
	 */
	public function execute() {
		parent::execute();
		
		if ($this->application->status == UserGroupApplication::STATUS_ACCEPTED || $this->application->status == UserGroupApplication::STATUS_CLOSED) {
			throw new PermissionDeniedException();
		}
		
		$applicationEditor = new UserGroupApplicationEditor($this->application);
		$applicationEditor->delete();
		$this->executed();
		
		// forward to user group list page
		HeaderUtil::redirect(LinkHandler::getInstance()->getLink('UserGroupList'));
		exit;
	}
}
