/**
 * Moderated user group-related classes.
 * 
 * @author	Alexander Ebert
 * @copyright	2001-2018 WoltLab GmbH
 * @license	GNU Lesser General Public License <http://opensource.org/licenses/lgpl-license.php>
 */

/**
 * ModeratedUserGroup namespace
 */
WCF.ModeratedUserGroup = { };

/**
 * Provides methods to add new members.
 * 
 * @param	integer		groupID
 */
WCF.ModeratedUserGroup.AddMembers = Class.extend({
	/**
	 * user group id
	 * @var	integer
	 */
	_groupID: 0,
	
	/**
	 * action proxy
	 * @var	WCF.Action.Proxy
	 */
	_proxy: null,
	
	/**
	 * Initializes the WCF.ModeratedUserGroup.AddMembers class
	 * 
	 * @param	integer		groupID
	 */
	init: function(groupID) {
		this._groupID = groupID;
		
		this._proxy = new WCF.Action.Proxy({
			failure: $.proxy(this._failure, this),
			success: $.proxy(this._success, this)
		});
		
		$('#addMembersForm').on('submit', function(event) {
			event.preventDefault();
		});
		
		new WCF.Search.User('#addMembersForm #username', null, false, [ ], false);
		
		$('#addMembersForm #username').keyup($.proxy(this._keyup, this));
	},
	
	/**
	 * Handles successful AJAX requests.
	 * 
	 * @param	object		data
	 * @param	string		textStatus
	 * @param	jQuery		jqXHR
	 */
	_success: function(data, textStatus, jqXHR) {
		// reset input field value
		$('#addMembersForm #username').val('');
		
		// show success message
		var $notification = new WCF.System.Notification(WCF.Language.get('wcf.user.moderatedUserGroups.members.add.success'));
		$notification.show(function() {
			window.location.reload();
		});
		
		$('#addMembersForm dl').removeClass('formError');
		$('#addMembersForm dl .innerError').remove();
	},
	
	/**
	 * Handles failures.
	 * 
	 * @param	object		data
	 */
	_failure: function(data) {
		if (data === null) return true;
		
		$('#addMembersForm dl .innerError').remove();
		$('#addMembersForm dl').addClass('formError');
		$('<small class="innerError">' + WCF.Language.get('wcf.user.moderatedUserGroups.members.add.error.'+data.returnValues.errorType) + '</small>').insertAfter($('#addMembersForm dl input'));
		
		return false;
	},
	
	/**
	 * Submits the form to add new members.
	 */
	_keyup: function(event) {
		if (event.keyCode == 13) {
			var $username = $(event.currentTarget).val();
			if ($username) {
				this._proxy.setOption('data', {
					actionName: 'addMemberByName',
					className: 'wcf\\data\\user\\group\\ModeratedUserGroupAction',
					objectIDs: [ this._groupID ],
					parameters: {
						username: $username
					}
				});
				this._proxy.sendRequest();
			}
		}
	}
});
