/**
 * Provides the thread form option add dialog.
 *
 * @author	Joshua Ruesweg
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @module	WoltLabSuite/Forum/Ui/Post/ThreadFormInline
 * @since       5.2
 */
define(['Ajax', 'AjaxRequest', 'EventHandler', 'Dictionary', 'Language'], function (Ajax, AjaxRequest, EventHandler, Dictionary, Language) {
	"use strict";
	
	if (!COMPILER_TARGET_DEFAULT) {
		var Fake = function() {};
		Fake.prototype = {
			init: function() {},
			registerElement: function() {},
			_getFormElements: function() {},
			_validate: function() {},
			_submit: function() {}
		};
		return Fake;
	}
	
	var _container;
	var _editorID;
	var _elements = new Dictionary();
	/**
	 * @exports     WoltLabSuite/Forum/Ui/Post/ThreadFormInline
	 */
	return {
		init: function(containerID, editorID) {
			_container = elById(containerID);
			_editorID = editorID;
			
			if (_container === null) {
				throw new Error("[WoltLabSuite/Forum/Ui/Post/ThreadFormInline] Unable to locate given container.");
			}
			
			EventHandler.add('com.woltlab.wcf.redactor2', 'submit_' + _editorID, this._submit.bind(this));
			EventHandler.add('com.woltlab.wcf.redactor2', 'validate_' + _editorID, this._validate.bind(this));
		},
		
		registerElement: function(elementID, valueCallback, elementRequired) {
			if (typeof elementRequired !== 'boolean') {
				elementRequired = true; 
			}
			
			if (typeof valueCallback !== 'function') {
				valueCallback = function (element) {
					return element.value;
				};
			}
			
			var data = {
				valueCallback: valueCallback,
				elementRequired: elementRequired
			};
			
			_elements.set(elementID, data);
		},
		
		_getFormElements: function() {
			var elements = {
				values: []
			};
			
			_elements.forEach(function (data, elementID) {
				var element = elById(elementID, _container);
				
				if (element === null && data.elementRequired) {
					throw new Error("[WoltLabSuite/Forum/Ui/Post/ThreadFormInline] Unable to locate given element '"+ elementID +"'.");
				}
				
				elements.values[elementID] = data.valueCallback(element);
			});
			
			return elements;
		},
		
		_validate: function(data) {
			data.promises.push(new Promise(function (resolve, reject) {
				Ajax.api({
					_ajaxSetup: function() {
						return {
							data: {
								className: 'wbb\\data\\post\\PostAction',
								actionName: 'validateThreadFormValues',
								objectIDs: [
									elData(_container.closest('article'), 'post-id')
								]
							}
						};
					}
				}, {
					parameters: this._getFormElements()
				}, function(data) {
					if (data.returnValues.errors.length === 0) {
						resolve();
					}
					else {
						for (var key in data.returnValues.errors) {
							if (!data.returnValues.errors.hasOwnProperty(key)) continue;
							var errorMessage = data.returnValues.errors[key];
							if (errorMessage === 'empty') {
								errorMessage = Language.get('wcf.global.form.error.empty');
							}
							else if (errorMessage === 'validationFailed') {
								errorMessage = Language.get('wcf.acp.customOption.error.validationFailed');
							}
							elInnerError(elBySel('#'+key, _container), errorMessage);
						}
						
						window.jQuery(".messageTabMenu[data-wysiwyg-container-id='"+ _editorID +"']").messageTabMenu('showTab', 'threadFormOptions', true);
						
						reject();
					}
				}, function () {
					reject(new Error('[WoltLabSuite/Forum/Ui/Post/ThreadFormInline] Unable to validate thread form data due an unknown validate error.'));
				});
			}.bind(this)));
		},
		
		_submit: function(data) {
			// append thread form elements to the request
			data.threadFormOptions = this._getFormElements();
		}
	};
});
