-- warnings
DROP TABLE IF EXISTS wcf1_user_infraction_warning;
CREATE TABLE wcf1_user_infraction_warning (
	userWarningID INT(10) NOT NULL AUTO_INCREMENT PRIMARY KEY,
	objectID INT(10) DEFAULT NULL,
	objectTypeID INT(10) DEFAULT NULL,
	userID INT(10) NOT NULL,
	judgeID INT(10) DEFAULT NULL,
	warningID INT(10) DEFAULT NULL,
	time INT(10) NOT NULL DEFAULT 0,
	title VARCHAR(255) NOT NULL DEFAULT '',
	points MEDIUMINT(7) NOT NULL DEFAULT 0,
	expires INT(10) NOT NULL DEFAULT 0,
	reason MEDIUMTEXT,
	revoked TINYINT(1) NOT NULL DEFAULT 0,
	revoker INT(10) DEFAULT NULL,
	KEY (judgeID),
	KEY (warningID),
	KEY (objectTypeID, objectID)
);

-- suspensions
DROP TABLE IF EXISTS wcf1_user_infraction_suspension;
CREATE TABLE wcf1_user_infraction_suspension (
	userSuspensionID INT(10) NOT NULL AUTO_INCREMENT PRIMARY KEY,
	userID INT(10) NOT NULL DEFAULT 0,
	suspensionID INT(10) NOT NULL DEFAULT 0,
	time INT(10) NOT NULL DEFAULT 0,
	expires INT(10) NOT NULL DEFAULT 0,
	revoked TINYINT(1) NOT NULL DEFAULT 0,
	revoker INT(10) DEFAULT NULL,
	warningID INT(10) DEFAULT NULL,
	KEY (suspensionID),
	KEY (userID)
);

-- predefined warnings
DROP TABLE IF EXISTS wcf1_infraction_warning;
CREATE TABLE wcf1_infraction_warning (
	warningID INT(10) NOT NULL AUTO_INCREMENT PRIMARY KEY,
	title VARCHAR(255) NOT NULL DEFAULT '',
	points MEDIUMINT(7) NOT NULL DEFAULT 0,
	expires INT(10) NOT NULL DEFAULT 0,
	reason MEDIUMTEXT
);

-- predefined suspensions
DROP TABLE IF EXISTS wcf1_infraction_suspension;
CREATE TABLE wcf1_infraction_suspension (
	suspensionID INT(10) NOT NULL AUTO_INCREMENT PRIMARY KEY,
	title VARCHAR(255) NOT NULL DEFAULT '',
	points MEDIUMINT(7) NOT NULL DEFAULT 0,
	expires INT(10) NOT NULL DEFAULT 0,
	objectTypeID INT(10) NOT NULL,
	suspensionData MEDIUMTEXT,
	KEY (objectTypeID)
);


ALTER TABLE wcf1_user_infraction_warning ADD FOREIGN KEY (userID) REFERENCES wcf1_user (userID) ON DELETE CASCADE;
ALTER TABLE wcf1_user_infraction_warning ADD FOREIGN KEY (judgeID) REFERENCES wcf1_user (userID) ON DELETE SET NULL;
ALTER TABLE wcf1_user_infraction_warning ADD FOREIGN KEY (objectTypeID) REFERENCES wcf1_object_type (objectTypeID) ON DELETE CASCADE;
ALTER TABLE wcf1_user_infraction_warning ADD FOREIGN KEY (warningID) REFERENCES wcf1_infraction_warning (warningID) ON DELETE SET NULL;

ALTER TABLE wcf1_user_infraction_suspension ADD FOREIGN KEY (userID) REFERENCES wcf1_user (userID) ON DELETE CASCADE;
ALTER TABLE wcf1_user_infraction_suspension ADD FOREIGN KEY (suspensionID) REFERENCES wcf1_infraction_suspension (suspensionID) ON DELETE CASCADE;
ALTER TABLE wcf1_user_infraction_suspension ADD FOREIGN KEY (warningID) REFERENCES wcf1_user_infraction_warning (userWarningID) ON DELETE SET NULL;

ALTER TABLE wcf1_infraction_suspension ADD FOREIGN KEY (objectTypeID) REFERENCES wcf1_object_type (objectTypeID) ON DELETE CASCADE;
