<?php
namespace wbb\system\worker;
use wbb\data\post\PostEditor;
use wbb\data\post\PostList;
use wbb\data\thread\ThreadList;
use wcf\system\search\SearchIndexManager;
use wcf\system\worker\AbstractRebuildDataWorker;
use wcf\system\WCF;

/**
 * Worker implementation for updating the search index of posts.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Worker
 * 
 * @method	PostList	getObjectList()
 */
class PostSearchIndexRebuildDataWorker extends AbstractRebuildDataWorker {
	/**
	 * @inheritDoc
	 */
	protected $limit = 1000;
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function countObjects() {
		if ($this->count === null) {
			$this->count = 0;
			$sql = "SELECT	MAX(postID) AS postID
				FROM	wbb".WCF_N."_post";
			$statement = WCF::getDB()->prepareStatement($sql);
			$statement->execute();
			$row = $statement->fetchArray();
			if ($row !== false) $this->count = $row['postID'];
		}
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	protected function initObjectList() {
		$this->objectList = new PostList();
		$this->objectList->sqlOrderBy = 'post.postID';
	}
	
	/**
	 * @inheritDoc
	 */
	public function execute() {
		$this->objectList->getConditionBuilder()->add('post.postID BETWEEN ? AND ?', [$this->limit * $this->loopCount + 1, $this->limit * $this->loopCount + $this->limit]);
		
		parent::execute();
		
		if (!$this->loopCount) {
			// reset search index
			SearchIndexManager::getInstance()->reset('com.woltlab.wbb.post');
		}
		
		if (!count($this->objectList)) {
			return;
		}
		
		// read associated threads
		$threadIDs = [];
		foreach ($this->objectList as $post) {
			$threadIDs[] = $post->threadID;
		}
		
		$threadList = new ThreadList();
		$threadList->setObjectIDs($threadIDs);
		$threadList->readObjects();
		$threads = $threadList->getObjects();
		
		foreach ($this->objectList as $post) {
			$post->setThread($threads[$post->threadID]);
			
			// update search index
			if ($post->getThread()->getBoard()->searchable) {
				PostEditor::addToSearchIndex([$post], false);
			}
		}
	}
}
