<?php
namespace wbb\system\worker;
use wbb\data\thread\ThreadAction;
use wcf\data\article\content\ArticleContentList;
use wcf\data\article\ArticleList;
use wcf\system\worker\AbstractRebuildDataWorker;
use wcf\system\WCF;

/**
 * Worker implementation for updating and creating discussion threads for articles.
 * 
 * @author	Marcel Werk
 * @copyright	2001-2019 WoltLab GmbH
 * @license	WoltLab License <http://www.woltlab.com/license-agreement.html>
 * @package	WoltLabSuite\Forum\System\Worker
 * 
 * @method	ArticleList	getObjectList()
 */
class ArticleThreadsRebuildDataWorker extends AbstractRebuildDataWorker {
	/**
	 * @inheritDoc
	 */
	protected $limit = 50;
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	public function countObjects() {
		if ($this->count === null) {
			$this->count = 0;
			$sql = "SELECT	MAX(articleID) AS articleID
				FROM	wcf".WCF_N."_article";
			$statement = WCF::getDB()->prepareStatement($sql);
			$statement->execute();
			$row = $statement->fetchArray();
			if ($row !== false) $this->count = $row['articleID'];
		}
	}
	
	/** @noinspection PhpMissingParentCallCommonInspection */
	/**
	 * @inheritDoc
	 */
	protected function initObjectList() {
		$this->objectList = new ArticleList();
		$this->objectList->sqlOrderBy = 'article.articleID';
	}
	
	/**
	 * @inheritDoc
	 */
	public function execute() {
		$this->objectList->getConditionBuilder()->add('article.articleID BETWEEN ? AND ?', [$this->limit * $this->loopCount + 1, $this->limit * $this->loopCount + $this->limit]);
		
		parent::execute();
		
		if (!count($this->objectList)) {
			return;
		}
		
		// get article ids
		$articleIDs = [];
		foreach ($this->getObjectList() as $article) {
			$articleIDs[] = $article->articleID;
		}
		
		$articleContentList = new ArticleContentList();
		$articleContentList->getConditionBuilder()->add("article_content.articleID IN (?)", [$articleIDs]);
		$articleContentList->readObjects();
		$contentToArticle = [];
		foreach ($articleContentList as $articleContent) {
			if (!isset($contentToArticle[$articleContent->articleID])) $contentToArticle[$articleContent->articleID] = [];
			$contentToArticle[$articleContent->articleID][] = $articleContent;
		}
		
		foreach ($this->getObjectList() as $article) {
			(new ThreadAction([], 'rebuildArticleThreads', [
				'article' => $article,
				'articleContents' => $contentToArticle[$article->articleID]
			]))->executeAction();
		}
	}
}
